import { Directive, ElementRef, forwardRef, HostListener, Renderer2 } from '@angular/core';
import { ControlValueAccessor, NG_VALUE_ACCESSOR } from '@angular/forms';

@Directive({
  selector: '[appContenteditableModel]',
  standalone: true,
  providers: [
    {
      provide: NG_VALUE_ACCESSOR,
      useExisting: forwardRef(() => ContenteditableModelDirective),
      multi: true
    }
  ]
})
export class ContenteditableModelDirective implements ControlValueAccessor {

  constructor(private elementRef: ElementRef, private renderer: Renderer2) { }

  @HostListener('input', ['$event.target.textContent']) onInput(value: string) {
    this.onChange(value);
  }

  onChange = (_: any) => { };
  onTouched = () => { };

  writeValue(value: any): void {
    const normalizedValue = value == null ? '' : value;
    this.renderer.setProperty(this.elementRef.nativeElement, 'textContent', normalizedValue);
  }

  registerOnChange(fn: any): void {
    this.onChange = fn;
  }

  registerOnTouched(fn: any): void {
    this.onTouched = fn;
  }
}