import { Directive, Input } from '@angular/core';
import { NG_VALIDATORS, Validator, AbstractControl } from '@angular/forms';

@Directive({
  selector: '[appMinLength]',
  standalone: true,
  providers: [
    {
      provide: NG_VALIDATORS,
      useExisting: MinLengthValidatorDirective,
      multi: true,
    },
  ],
})
export class MinLengthValidatorDirective implements Validator {
  @Input('appMinLength') minLengthValue!: any;
  @Input('LengthTextFieldStatus') LengthTextFieldStatus!: any;

  validate(control: AbstractControl): { [key: string]: any } | null {
    
    if(this.LengthTextFieldStatus != "on" || (this.minLengthValue == null || this.minLengthValue == "" || this.minLengthValue == 0)){
      return null;
    }
    const minLength = this.minLengthValue;
    const value = this.getTextContent(control.value.trim());
    if (value == "<p><br></p>" || value?.length == 0 || value && value.length < minLength) {
      return {minLength : {
        minlength : 'less characters'
      }}
    }
    return null
  }
  getTextContent(html: string): string {
    const div = document.createElement('div');
    div.innerHTML = html;
    return div.textContent || div.innerText || '';
  }
}
