// timeout.guard.ts
import { Injectable } from '@angular/core';
import { ActivatedRouteSnapshot, RouterStateSnapshot, Router, NavigationEnd } from '@angular/router';
import { Observable, of } from 'rxjs';
import { filter } from 'rxjs/operators';
import Swal from 'sweetalert2';
import { TranslatePipes } from '../pipes/translate/translate.pipe';
import { CustomersService } from '../services/customers/customers.service';
import { CustomerDataService } from '../services/admin/customer-data.service';
import { CustomerTimerService } from '../services/customerTimer.service';

@Injectable({
  providedIn: 'root'
})
export class CustomerTimeoutGuard {
  innerTimerValue;
  constructor(private customertimerService: CustomerTimerService, private router: Router, private customerService: CustomersService, private translatePipe: TranslatePipes, private customerDataService: CustomerDataService) {
    this.customertimerService.loadStateFromStorage();
  }
  canActivate(
    next: ActivatedRouteSnapshot,
    state: RouterStateSnapshot
  ): Observable<boolean> | Promise<boolean> {
    let data = this.customerDataService.getSharedData();
    if (data?.customer_inactive_auto_logout == "on" || data?.customer_inactive_auto_logout == true) {
      const inactivityDuration = Number(data?.customer_inactive_auto_logout_time) * 60;

      this.customertimerService.startTimer(inactivityDuration);

      this.router.events.pipe(filter((event) => event instanceof NavigationEnd)).subscribe(() => {
        let data = this.customerDataService.getSharedData();
        const inactivityDuration = data?.customer_inactive_auto_logout_time * 60;
        if(inactivityDuration){
        this.customertimerService.resetTimer(inactivityDuration);
        }
      });

      return new Observable<boolean>((observer) => {
        const subscription = this.customertimerService.getTimerObservable().subscribe((timer) => {          
          if (timer === 0) {
            Swal.fire({
              title: '<h4 class="fw-semibold mb-1">' + this.translatePipe.transform('You have been inactive since last') + data?.customer_inactive_auto_logout_time + this.translatePipe.transform('minutes. Do you wish to stay?') + '</h4>',
              icon: 'warning',
              allowOutsideClick: false,
              showConfirmButton: true,
              confirmButtonText: this.translatePipe.transform('Stay Signed In'),
              didOpen: () => {
                this.customertimerService.stopTimer()
                this.customertimerService.startInnerTimer(60);
                const innerSubscription = this.customertimerService.getInnerTimerObservable().subscribe((innertimer) => {
                  const storedState = localStorage.getItem('cust_session_timer');
                  if (storedState) {
                    const { custtimer } = JSON.parse(storedState);
                    if (custtimer > 0) {
                      this.customertimerService.stopInnerTimer();
                      innerSubscription.unsubscribe();
                      Swal.close();
                    }
                  }
                  this.innerTimerValue = '<span class="d-block text-muted fw-normal">' + this.translatePipe.transform('Your session will be timed out in') + '<h3 class="countdown mb-0">' + innertimer + '</h3>' + this.translatePipe.transform('seconds'); +'</span>';

                  Swal.update({
                    html: this.innerTimerValue,
                  });
                  if (innertimer === 0) {
                    subscription.unsubscribe();
                    innerSubscription.unsubscribe();
                    this.customertimerService.stopInnerTimer();
                    this.customerLogout();
                    Swal.close();
                  }
                });
              },
            }).then((result) => {
              if (result.isConfirmed) {
                this.customertimerService.resetTimer(inactivityDuration);
                this.customertimerService.stopInnerTimer();
                observer.next(true);
                observer.complete();
              }
            });
          } else {
            observer.next(true);
            observer.complete();
          }
        });
      });
    }
    return of(true);
  }

  customerLogout$;
  customerLogout() {
    const data = {

    };
    this.customerLogout$ = this.customerService.customerLogout(data)
      .subscribe({
        next: (res) => {
          localStorage.clear();
          if (res?.success && !res?.redirect) {
            this.router.navigate(['/customer/login']);
          }
          if (res?.success && res?.redirect) {
            this.router.navigate(['/']);
          }
          history.pushState(null, '');
          this.customerLogout$.unsubscribe();
        }
      });
  }
}
