import { Component, ComponentFactoryResolver, ElementRef, OnInit, ViewChild, ViewContainerRef } from '@angular/core';
import { Subscription, takeUntil } from 'rxjs';
import { Unsub } from '../../class/unsub.class';
import { AdminProfileService } from '../../services/admin/admin-profile.service';
import { AdminService } from '../../services/admin/admin.service';
import { MenuData } from '../../interfaces/interfaces';
import { LoaderService } from '../../services/loader.service';
import { CommentMessageComponent } from '../../../components/admin/liveChat/chat-interface/comment-message/comment-message.component';
import { CustomerMessageComponent } from '../../../components/admin/liveChat/chat-interface/customer-message/customer-message.component';
import { FeedbackCommentComponent } from '../../../components/admin/liveChat/chat-interface/feedback-comment/feedback-comment.component';
import { CustomerMessageTypingComponent } from '../../../components/admin/liveChat/chat-interface/customer-message-typing/customer-message-typing.component';
import { LivechatSocketService } from '../../services/livechat-socket.service';
import { LiveChatService } from '../../services/admin/livechat.service';
import { LivechatDataService } from '../../services/livechat-data.service';
import { OperatorschatDataService } from '../../services/operatorschat-data.service';

@Component({
  selector: 'app-admin-layout',
  templateUrl: './admin-layout.component.html',
  styleUrls: ['./admin-layout.component.scss'],
})
export class AdminLayoutComponent extends Unsub implements OnInit {
  private dynamicListSub!: Subscription;
  pastMessage = '';
  // @Input() pastMessage = '';
  setting;
  dynamicList;
  refresh$;
  maintainceMode$;
  settingInprogress$;
  downloadTimer;
  checking = true;
  timeleft = 60;
  href;
  base;
  currentSocketId = undefined;
  AuthId = 0;
    public newUserAdded: { [key: string]: boolean } = {};
    token;
  constructor(
    private adminService: AdminService,
    private adminProfileService: AdminProfileService,private livechatDataService: LivechatDataService, 
    private OperatorschatDataService: OperatorschatDataService,
    private viewContainerRef: ViewContainerRef,
    private livechatSocketService: LivechatSocketService,
    private livechatService:LiveChatService,
    loaderService: LoaderService
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
    this.href = location.origin;
    this.base = document.querySelector('base')?.getAttribute('href');

  }
  OpenUserInfo = [];
  newMessageSoundCurrentAudio:any = "";
  loadedEventTriger = false
  beforeUnloadHandler(e) {    
    if (this.loadedEventTriger) {
        let tabsOpen:number | string = localStorage.getItem('tabsOpen');
        if (tabsOpen) {
            tabsOpen = parseInt(tabsOpen) - 1;
            if (tabsOpen <= 0) {
                let data = {
                    users: "",
                    onlineUserUpdated: true
                }
                
                this.livechatService.livechatOnlineUsersSave(data).subscribe({
                  next : ()=> {

                  }
                })
                localStorage.removeItem('tabsOpen');
            }
            // localStorage.setItem('tabsOpen', tabsOpen.toString());
        }
    }
  }
  ngOnInit(): void {
  
    this.loadedEventTriger = true
    // To check the tabs Open
    let tabsOpen:number | string = localStorage.getItem('tabsOpen');
    tabsOpen = tabsOpen ? parseInt(tabsOpen) + 1 : 1;
    localStorage.setItem('tabsOpen', tabsOpen.toString());
    //For Title
    this.adminLayout();

    this.refresh$ = this.adminService.RefreshRquestAdmin$.pipe(
      takeUntil(this.unSubscribe$)
    ).subscribe({
      next: () => {
        this.adminLayout();
      },
    });

    this.dynamicListSub = this.livechatSocketService.getDynamicListObservable().subscribe(dynamicList => {
      this.dynamicList = dynamicList;
      // Perform any additional logic upon receiving dynamicList update
    });

    
  }
  ///Dark Mode
  profileData!: MenuData;
  
  notify = (socket,SenderImage) =>{
    navigator.serviceWorker.ready.then(function(registration) {
        registration.showNotification(socket.senderName, {
            body: socket.message,
            icon: SenderImage ? `uploads/profile/${SenderImage}` : `uploads/profile/user-profile.png`,
            data: {
                link: this.href + this.base + `/admin/operators`
            }
        });
    })
}

  adminLayout() {
    this.settingInprogress$ = this.adminProfileService.adminLayout().pipe(
      takeUntil(this.unSubscribe$)
    ).subscribe({
      next: (ele) => {
        this.profileData = ele;
        this.AuthId = ele?.users?.id;
        this.setting = ele.setting?.original;
        if (ele.setting?.original?.sidemenu_icon_style == 'on') {
          document.body.classList.add('icon-overlay', 'sidenav-toggled');
        } else {
          if (innerWidth >= 992) {
            document.body.classList.remove('icon-overlay', 'sidenav-toggled');
          }
        }
        
      },
    });
  }
  onlineUsersFindChannel;
  ngAfterViewInit(): void {
        //LiveChat  Online users induction logic
        this.onlineUsersFindChannel = (window as any).Echo?.join('angularagentMessage');
        // For the Operators Notifications
        this.onlineUsersFindChannel?.listen('AgentMessageEvent', (socket) => {
            // For the Agent To Agent Chat
            if (this.AuthId == socket.receiverId && !socket.groupInclude && socket.message &&
                this.setting?.operatorsAgentToAgentSound && parseInt(this.setting?.operatorsAgentToAgentWebNot) && parseInt(
                    this.setting?.operatorsNotificationsSounds)) {
                let allUsers = socket.users ??[]
                let SenderImage = allUsers.filter((arr) => parseInt(arr.id) == parseInt(
                    socket.senderId))[0].image

                // For the Window notification
                if ("Notification" in window) {
                    if (Notification.permission === "granted") {
                        this.notify(socket,SenderImage);
                    } else {
                        Notification.requestPermission().then(res => {
                            if (res === "granted") {
                                this.notify(socket,SenderImage);
                            } else {
                                console.error("Did not receive permission for notifications");
                            }
                        })
                    }
                } else {
                    console.error("Browser does not support notifications");
                }

                // Stop the current audio if it exists
                if (this.newMessageSoundCurrentAudio) {
                    this.newMessageSoundCurrentAudio?.['pause']();
                    this.newMessageSoundCurrentAudio['currentTime'] = 0;
                }

                // Create a new audio element
                let audioElement = document.createElement('audio');
                audioElement.id = "audioPlayer";
                audioElement.innerHTML = `
                    <source src="{{ url('') }}/assets/sounds/${this.setting?.operatorsAgentToAgentSound}">
                `;

                // Play the new audio
                if (audioElement.paused) {
                    audioElement.play();
                }
                this.newMessageSoundCurrentAudio = audioElement;

            }

            let groupId = Array.isArray(socket.groupInclude) ? socket.groupInclude : JSON.parse(socket.groupInclude) ?? [];
            // For the Grop messages
            if (groupId.length && groupId.includes(this.AuthId) &&
                socket.message && this.setting?.operatorsGroupChatSound && parseInt(this.setting?.operatorsGroupChatWebNot) &&
                parseInt(this.setting?.operatorsNotificationsSounds) && socket.senderId != this.AuthId) {

                // For the Window notification
                if ("Notification" in window) {
                    if (Notification.permission === "granted") {
                        this.notify(socket,null);
                    } else {
                        Notification.requestPermission().then(res => {
                            if (res === "granted") {
                                this.notify(socket,null);
                            } else {
                                console.error("Did not receive permission for notifications");
                            }
                        })
                    }
                } else {
                    console.error("Browser does not support notifications");
                }

                //   function notify() {
                //       navigator.serviceWorker.ready.then(function(registration) {
                //           registration.showNotification(socket.senderName, {
                //               body: socket.message,
                //               icon: this.href + this.base + `uploads/profile/group.png`,
                //               data: {
                //                   link: this.href + this.base + `/admin/operators`
                //               }
                //           });
                //       })
                //   }

                // Stop the current audio if it exists
                if (this.newMessageSoundCurrentAudio) {
                    this.newMessageSoundCurrentAudio.pause();
                    this.newMessageSoundCurrentAudio.currentTime = 0;
                }

                // Create a new audio element
                let audioElement = document.createElement('audio');
                audioElement.id = "audioPlayer";
                audioElement.innerHTML = `
                    <source src="{{ url('') }}/assets/sounds/${this.setting?.operatorsGroupChatSound}">
                `;

                // Play the new audio
                if (audioElement.paused) {
                    audioElement.play();
                }
                this.newMessageSoundCurrentAudio = audioElement;
            }

            // Used to check for the current and old charts are same or not if they are not same remove the typing users.
            if(!this.currentSocketId){
                this.currentSocketId = socket.customerId;
            }
            else if(this.currentSocketId != socket.customerId){
                this.OperatorschatDataService.clearWriting();
                this.currentSocketId = socket.customerId;
            }
            // For the Messages Add      
            if(!socket?.typingMessage){
                this.OperatorschatDataService.removeWriting(socket?.senderId);
            }
            if(socket.messageType != "feedBack" && socket.typingMessage){            
                this.OperatorschatDataService.updateWriting({id: socket.receiverId, userId : socket.senderId, msg : socket.typingMessage, userName : socket.senderName, typing: true, groupInclude : socket.groupInclude})      
            }
        })
        this.onlineUsersFindChannel?.here((users) => {            
            let data = {
                users: JSON.stringify(users),
                onlineUserUpdated: true
            }
            this.livechatService.livechatOnlineUsersSave(data).subscribe({
            next : (res)=> {
            }
            })

            // adding the window close alert
            if (users.length == 1 && users[0].id == "{{ Auth::user()->id }}") {
                this.OpenUserInfo = users
                window.addEventListener('beforeunload', this.beforeUnloadHandler);
            }
        })
        this.onlineUsersFindChannel?.joining((user) => {  
            let data = {
                users: JSON.stringify(Object.values(this.onlineUsersFindChannel.subscription.members
                    .members)),
                onlineUserUpdated: true
            }
            this.livechatService.livechatOnlineUsersSave(data).subscribe({
            next : (res)=> {
            }
            })

            // removing the window close alert
            if (JSON.parse(data.users).length > 1) {
                window.removeEventListener('beforeunload', this.beforeUnloadHandler);
            }
        })
        this.onlineUsersFindChannel?.leaving((user) => {
            let data = {
                users: JSON.stringify(Object.values(this.onlineUsersFindChannel.subscription.members
                    .members)),
                onlineUserUpdated: true
            }
        
            this.livechatService.livechatOnlineUsersSave(data).subscribe({
            next : (res)=> {
            }
            })

            // removing the window close alert
            if (JSON.parse(data.users).length > 1) {
                window.removeEventListener('beforeunload', this.beforeUnloadHandler);
            } else {
                this.OpenUserInfo = JSON.parse(data.users)
                window.addEventListener('beforeunload', this.beforeUnloadHandler);
            }
        });   
        (window as any).Echo?.channel('angularliveChat').listen('ChatMessageEvent',(socket)=>{
                
            let msg:string = socket.message;
            // Used to check for the current and old charts are same or not if they are not same remove the typing users.
            if(!this.currentSocketId){
                this.currentSocketId = socket.customerId;
            }
            else if(this.currentSocketId != socket.customerId){
                this.livechatDataService.clearWriting();
                this.currentSocketId = socket.customerId;
            }
            
            let customerIdEle = document.querySelector(`.checkforactive[data-id='${socket.customerId}']`) as HTMLElement;
            let operatorConversationInfo = document.querySelector(`#operator-conversation-Info[data-id="${socket.customerId}"]`) as HTMLElement;
            let chatMsgScroll = document.querySelector(`#chat-msg-scroll [data-id='${socket.customerId}'] .avatar-status`) as HTMLElement;
            // Conversation Messages
            let liveChatConversation = document.querySelector("#operator-conversation") as HTMLElement;
            let operatorConversationId = document.querySelector(`#operator-conversation[operator-id="${socket.customerId}"]`) as HTMLElement;
            let typingIndication = document.querySelector("#typingIndication") as HTMLElement;
            let engageConversation = document.querySelector('.engageConversation') as HTMLElement;
            // For Customer Online Update
            if(socket.customerId && socket.onlineStatusUpdate){
                if(socket.onlineStatusUpdate == 'offline'){
                    chatMsgScroll?.classList.remove("bg-green")
                    if(operatorConversationInfo?.querySelector(`.chatpersonstatus`)){
                        (operatorConversationInfo.querySelector(`.chatpersonstatus`)as HTMLElement).innerText = "offline"
                        operatorConversationInfo.querySelector(`.avatar-status`)?.classList.remove("bg-green")
                        operatorConversationInfo.querySelector(`.chatpersonstatus`)?.classList.remove('text-green')
                        operatorConversationInfo.querySelector(`.chatpersonstatus`)?.classList.add('text-muted')
                    }
                }
                if(socket.onlineStatusUpdate == 'online'){
                    chatMsgScroll?.classList.add("bg-green")
                    if(operatorConversationInfo?.querySelector(`.chatpersonstatus`)){
                        (operatorConversationInfo.querySelector(`.chatpersonstatus`)as HTMLElement).innerText = "online"
                        operatorConversationInfo.querySelector(`.avatar-status`)?.classList.add("bg-green")
                        operatorConversationInfo.querySelector(`.chatpersonstatus`)?.classList.add('text-green')
                        operatorConversationInfo.querySelector(`.chatpersonstatus`)?.classList.remove('text-muted')
                    }
                }
            }

            // For the New Customer was created
            if(msg == "newUser" && !socket.customerId){
                this.newUserAdded[socket.id] = true;
            }
            if(this.newUserAdded[socket.id] && !customerIdEle && socket.customerId){        
                this.livechatDataService.appendData(socket)
                this.newUserAdded[socket.id] = false;
            }

            // To Update the Message in the Side Bar
            if(customerIdEle && msg){
                // this.sharedDataService.appendData(newItem);
                (customerIdEle.querySelector(`.chat-msg`) as HTMLElement).innerText = msg;
                (customerIdEle.querySelector(`.chat-time`) as HTMLElement).innerText = `${((new Date().getHours() + 11) % 12) + 1}:${new Date().getMinutes()}${new Date().getHours() >= 12 ? "PM" : "AM"}`
                if(!customerIdEle?.classList.contains("active")){
                    customerIdEle.querySelector(`.chat-msg`)?.classList.add("font-weight-bold")
                }
                // clearTimeout(debounceTimeout4);
                // pastMessage.__proto__.customerId = ""

                // For the update unread index number
                if(socket.customerId == socket.id && !customerIdEle?.classList.contains("active")){
                    let unReadIndexNumberVar : HTMLElement | null= customerIdEle.querySelector(`.unReadIndexNumber`)
                    if(unReadIndexNumberVar){
                        unReadIndexNumberVar.innerText = JSON.stringify(parseInt(unReadIndexNumberVar.innerText) + 1);
                    }else{
                        var chatMsgSpan = customerIdEle.querySelector(`.chat-msg`);
                        var newSpan = document.createElement('span');
                        newSpan.className = 'ms-auto me-2 badge bg-success-transparent rounded-circle unReadIndexNumber';
                        newSpan.textContent = '1';
                        chatMsgSpan?.parentNode?.insertBefore(newSpan, chatMsgSpan.nextSibling);
                    }
                }

                // To add the Top in the Sidebar
                document.querySelector("#chat-msg-scroll")?.insertBefore(customerIdEle as HTMLElement, document.querySelector("#chat-msg-scroll > li"))
            }


            // Update the Users in the sidebar when join, reassign, and leave. and also comments
            if(customerIdEle && socket.engageUser && socket.agentInfo && socket.comments){
                let ChatIncludeUsers = socket.agentInfo ? JSON.parse(socket.agentInfo) : [];
                ChatIncludeUsers?.forEach((e, i)=>{
                    if(e.id == this.AuthId){
                        customerIdEle?.classList.add('moveout')

                        if (document.querySelector('.main-chart-wrapper')?.querySelector('#operator-conversation-Info')?.getAttribute('data-id') == socket.customerId) {
                            document.querySelector('.textareaDiv')?.classList.remove('d-none');
                            engageConversation?.classList.add('d-none');
                        }
                    } else {

                        let avatarDiv = document.createElement("div")
                        ChatIncludeUsers?.map((ele,index)=>{
                            if(index <= 1){
                                let avatarSpan = document.createElement("span")
                                avatarSpan.className = "avatar brround avatar-sm"
                                avatarSpan.style.backgroundImage = `url(uploads/profile/${ele.image ? ele.image : 'user-profile.png'})`
                                avatarSpan.innerText = ""
                                avatarSpan.setAttribute("data-bs-toggle","tooltip")
                                avatarSpan.setAttribute("data-bs-placement","top")
                                avatarSpan.setAttribute("data-bs-title",ele.name)
                                avatarDiv.appendChild(avatarSpan)
                            }
                        })
                        if(ChatIncludeUsers?.length > 2){
                            let avatarSpan = document.createElement("span")
                            avatarSpan.className = "avatar brround bg-light text-dark avatar-sm"
                            avatarSpan.innerText = `+${ChatIncludeUsers.length-2}`
                            avatarSpan.setAttribute("data-bs-toggle","tooltip")
                            avatarSpan.setAttribute("data-bs-placement","top")
                            let fullNames = ChatIncludeUsers.map(item => `${item.firstname} ${item.lastname}`);
                            avatarSpan.setAttribute("data-bs-title",fullNames)
                            avatarDiv.appendChild(avatarSpan)
                        }

                        // To add in the Sidebar
                        if(customerIdEle.querySelector(`.avatar-list`)){
                            (customerIdEle.querySelector(`.avatar-list`) as HTMLElement).innerHTML = avatarDiv.innerHTML

                            // The Leave button Update .
                            if(avatarDiv.querySelectorAll("span").length > 1){
                                let leaveLiElement = document.createElement("li")
                                leaveLiElement.innerHTML = `
                                <a class="dropdown-item" href="{{route('admin.conversationLeave')}}?id=${socket.customerId}">
                                    <i class="ri-chat-delete-line align-middle me-2 fs-18"></i>
                                    Leave
                                </a>
                                `
                                customerIdEle.querySelector(`.dropdown-menu`)?.appendChild(leaveLiElement)
                            }else{
                                customerIdEle.querySelectorAll(`.dropdown-menu li`).forEach((element:any)=>{
                                    if(element.textContent.replace(/\s+/g, ' ').trim() == 'Leave'){
                                        element.remove()
                                    }
                                })
                            }

                            (customerIdEle.querySelector(`.custrecentmessage`) as HTMLElement).innerHTML = socket.comments
                            if(!customerIdEle?.classList.contains("active")){
                                customerIdEle.querySelector(`.custrecentmessage`)?.classList.add("font-weight-bold")
                            }
                            (customerIdEle.querySelector(`.chat-time`) as HTMLElement).innerHTML = `${((new Date().getHours() + 11) % 12) + 1}:${new Date().getMinutes()}${new Date().getHours() >= 12 ? "PM" : "AM"}`
                        }
                        // To adding comments in the conversation
                        if(operatorConversationId){
                            typingIndication?.remove()

                            const commentMessageRef = this.viewContainerRef.createComponent(CommentMessageComponent);
                            commentMessageRef.instance.data = socket;
                            commentMessageRef.instance.formatTime = this.livechatSocketService.formatTime;
                            commentMessageRef.instance.autoUserInfo = localStorage.getItem('user') ? JSON.parse(localStorage.getItem('user') as string) : null;
                            
                            this.dynamicList?.nativeElement.appendChild(commentMessageRef.location.nativeElement);

                            // To Scroll Down the Conversation
                            liveChatConversation?.scrollBy(0, liveChatConversation.scrollHeight)
                        }
                        // $('[data-bs-toggle="tooltip"]').tooltip();
                    }
                })

            }

            // For the Slove the Chat remove that chat in the side bar
            if(socket.comments && socket.comments.includes('Solved') && socket.customerId){
                customerIdEle?.remove()
                operatorConversationInfo?.remove()
                operatorConversationId?.remove()
                // if(socket.id == this.id){
                //   this.router.navigate([`/admin/live-chat/solved-chats`], { queryParams: { id: this.id }})
                // }
            }

            // To remove the customer from the sidebar if any user join
            if(customerIdEle && socket.engageUser && socket.id != this.AuthId && !location.href.includes('operatorID')){
                customerIdEle?.remove()
                operatorConversationInfo?.remove()
                operatorConversationId?.remove()
                engageConversation?.classList.add("d-none")
                if(document.querySelector("#chat-msg-scroll li")?.getAttribute("data-id")){
                    // sideMenuOpenClickFunction(document.querySelector(`.checkforactive[data-id="${document.querySelector("#chat-msg-scroll li")?.getAttribute("data-id")}"]`))
                }else{
                    // location.reload()
                }
            }

            // For The Message statusUpdate
            if(socket.userMessageStatusUpdate && socket.customerId){
                document.querySelectorAll(`#operator-conversation[operator-id="${socket.customerId}"] .msg-sent-time .chat-read-icon`).forEach((element)=>{
                    element.classList.add('chat-read-mark')
                    element.classList.remove('chat-read-icon')
                    if(element.querySelector('.ri-check-fill')){
                        (element.querySelector('.ri-check-fill') as HTMLElement).className = "ri-check-double-line"
                    }
                })
            }
            
            // For the Messages Add      
            if(!socket?.typingMessage){
                this.livechatDataService.removeWriting(socket?.agentInfo ? socket?.id : 'cust' + socket?.id);
            }
            if(socket.messageType != "feedBack" && socket.agentInfo && !msg && socket.typingMessage){            
                this.livechatDataService.updateWriting({id: socket.customerId, userId : JSON.parse(socket?.agentInfo)?.id, msg : socket.typingMessage, userName : socket.userName, admin: true, typing: true, groupInclude : socket.groupInclude})      
            }
            if(socket.messageType != "feedBack" && socket.agentInfo && msg && msg != "newUser" && !socket.typingMessage){
                this.livechatDataService.updateConversationData(socket);
            }
            if(socket.messageType != "feedBack"  && !socket.agentInfo && (socket.customerId == Number(liveChatConversation?.getAttribute("operator-id")) || socket.id == Number(liveChatConversation?.getAttribute("operator-id"))) && msg && msg != "newUser" && socket.id != this.AuthId && !socket.typingMessage){
                this.livechatDataService.updateConversationData(socket);
                liveChatConversation?.scrollBy(0, liveChatConversation.scrollHeight)
            }

            // For the feedBack Form comment add
            if(socket.messageType == "feedBack" && socket.customerId == liveChatConversation?.getAttribute("operator-id") && msg){
                let FeedbackMessage = JSON.parse(msg);
                const feedbackMessageRef = this.viewContainerRef.createComponent(FeedbackCommentComponent);
                feedbackMessageRef.instance.data = FeedbackMessage;
                this.dynamicList?.nativeElement.appendChild(feedbackMessageRef.location.nativeElement);
                // To Scroll Down the Conversation
                liveChatConversation?.scrollBy(0, liveChatConversation.scrollHeight)

            }
            // To add Typing Indication for the customer
            if(socket.typingMessage && liveChatConversation?.getAttribute("operator-id") == socket.customerId && !socket.agentInfo){
                this.livechatDataService.updateWriting({id: socket.customerId, userId : 'cust' +socket.customerId, msg : socket.typingMessage, userName : socket.userName, admin : false, typing: true, groupInclude:socket.groupInclude});
            }

        })
  }
  
  override ngOnDestroy(): void {
    this.dynamicListSub.unsubscribe();
    
    this.onlineUsersFindChannel?.leaving((user) => {
        let data = {
            users: JSON.stringify(Object.values(this.onlineUsersFindChannel.subscription.members
                .members)),
            onlineUserUpdated: true
        }
    
        this.livechatService.livechatOnlineUsersSave(data).subscribe({
        next : (res)=> {
        }
        })

        // removing the window close alert
        if (JSON.parse(data.users).length > 1) {
            window.removeEventListener('beforeunload', this.beforeUnloadHandler);
        } else {
            this.OpenUserInfo = JSON.parse(data.users)
            window.addEventListener('beforeunload', this.beforeUnloadHandler);
        }
    }); 
  }
}
