import { ChangeDetectorRef, Component, ElementRef, OnInit, QueryList, ViewChild, viewChild } from '@angular/core';
import { Router } from '@angular/router';
import { takeUntil } from 'rxjs';
import { Unsub } from '../../class/unsub.class';
import { AdminService } from '../../services/admin/admin.service';
import { GuestService } from '../../services/guest.service';
import { LoaderService } from '../../services/loader.service';
@Component({
  selector: 'app-guest-layout',
  templateUrl: './guest-layout.component.html',
  styleUrls: ['./guest-layout.component.scss'],
})
export class GuestLayoutComponent extends Unsub implements OnInit {
  data;
  hideAlertsUntil: { [key: string]: number } = {};
  constructor(private guestService: GuestService, private router: Router, private adminService: AdminService,  loaderService: LoaderService) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);


    
  }
    

  ngOnInit(): void {
    this.announcements();
    this.adminService.RefreshRquestAdmin$.pipe(
      takeUntil(this.unSubscribe$)
    ).subscribe({
      next: () => {
        this.announcements();
      }
    });
  }
  
  announcements() {
    this.guestService.getannouncments().subscribe({
      next: (res) => {
        this.data = res;    
        if (res.setting?.original?.defaultlogin_on == 'on' && (this.router.url == '/' || this.router.url == '/home')) {
          this.router.navigate(['/customer']);
        }
        if (res?.CUSTOMCHATENABLE == 'enable') {
          if (res?.CUSTOMCHATUSER == 'public') {
            if (document.querySelector('.customexternalchart')) {
              document.querySelectorAll('.customexternalchart').forEach(e => e.remove());
            }
            this.guestService.addExternalScript(res?.CUSTOMCHAT);
          } else if (res?.CUSTOMCHATUSER == 'user') {
            if (res?.customer) {
              if (document.querySelector('.customexternalchart')) {
                document.querySelectorAll('.customexternalchart').forEach(e => e.remove());
              }
              this.guestService.addExternalScript(res?.CUSTOMCHAT);
            }
          }
        } else {
          if (document.querySelector('.customexternalchart')) {
            document.querySelectorAll('.customexternalchart').forEach(e => e.remove());
          }
        }
      },
    });
  }
}
