import { Pipe, PipeTransform } from '@angular/core';

@Pipe({
  name: 'jsonParse',
  standalone: true
})
export class JsonParsePipe implements PipeTransform {

  transform(value: string): any[] {
    try {
      return JSON.parse(value);
    } catch (error) {
      console.error('Error parsing JSON:', error);
      return []; // Handle error gracefully (e.g., return an empty array)
    }
  }

}
