import { Pipe, PipeTransform } from '@angular/core';
import { DatePipe } from '@angular/common';
import moment from 'moment-timezone';

@Pipe({
  name: 'custtimezone',
  standalone: true
})
export class TimezonePipe implements PipeTransform {
  constructor(private datePipe: DatePipe) {}
  transform(value: any | Date, dateFormat, timeFormat, timezone: string = 'UTC') {
    

    if (!value) return value as string;
    
    // First, format the date using Angular's DatePipe
    if(dateFormat){
      const formattedDate = this.datePipe.transform(value, dateFormat);
      return formattedDate;
    }

    // Convert the formatted date to the desired timezone using moment-timezone (if needed)
    if(timeFormat){
      const dateInTimezone = moment(value).tz(timezone).format(timeFormat);
      return dateInTimezone;
    }
    
    // Return the formatted date and time based on the timezone conversion
    return value;
  }
}