import { Pipe, PipeTransform } from '@angular/core';
import { TranslateService } from '@ngx-translate/core';
import { LanguagesService } from '../../services/admin/languages.service';

@Pipe({
  standalone: true,
  name: 'translate',
  pure: true,
})
export class TranslatePipes implements PipeTransform {
  constructor(private translateService: TranslateService, private languageService: LanguagesService) {}

  transform(key: string): string {
    const translations = this.translateService.translations[this.translateService.currentLang];

    if (translations && key) {
      const lowercaseKey = key.toLowerCase();
      for (const objKey in translations.translation) {
        if(objKey){
          if (objKey.toLowerCase() === lowercaseKey) {
            
            if(translations.translation[objKey]){
              return translations.translation[objKey];
            }
            else{
              return key;
            }
          }
        }
      }
      if(key){
        this.languageService.addData(key);
      }
    }

    return key;
  } 
}
