import { Routes } from '@angular/router';
import { CanDeactivateGuard } from '../guard/CanDeactivateGuard.guard';

export const admin: Routes = [
  {
    path: 'dashboard',
    loadComponent: () => import('../../components/admin/dashboard/dashboard/dashboard.component').then(m => m.DashboardComponent),
    data: {
      permission: true
    }
  },
  {
    path: '',
    loadChildren: () => import('../../components/admin/admin-routing.module').then(m => m.admin)
  },
  {
    path: 'addons',
    loadComponent: () => import('../../components/admin/addons/addons.component').then(m => m.AddonsComponent),
    data: {
      permission: 'Addon Access'
    }
  },
  {
    path: 'addspace',
    loadComponent: () => import('../../components/admin/add-space/add-space.component').then(m => m.AddSpaceComponent),
    data: {
      permission: 'Addspace Access'
    }
  },
  {
    path: 'currency',
    loadComponent: () => import('../../components/admin/currency/currency.component').then(m => m.CurrencyComponent),
    data: {
      permission: 'Currencies Access'
    }
  },
  {
    path: 'announcements',
    loadComponent: () => import('../../components/admin/announcements/announcements.component').then(m => m.AnnouncementsComponent),
    data: {
      permission: 'Announcements Access'
    }
  },
  {
    path: 'global-tickets',
    loadChildren: () => import('../../components/admin/global-tickets/global-tickets-routing.module').then(m => m.globaltickets)
  },
  {
    path: 'business-hours',
    loadComponent: () => import('../../components/admin/business-hours/business-hours.component').then(m => m.BusinessHoursComponent),data: {
      permission: 'Business Hours Access'
    }
  },
  {
    path: 'canned-response',
    loadChildren: () => import('../../components/admin/cannedresponse/canned-response-routing.module').then(m => m.cannedResponse)
  },
  {
    path: 'self-tickets',
    loadChildren: () => import('../../components/admin/self-tickets/self-tickets-routing.module').then(m => m.selfTickets)
  },
  {
    path: 'live-chat',
    loadChildren: () => import('../../components/admin/liveChat/livechat-routing.module').then(m => m.liveChatRouting)
  },
  {
    path: 'tickets',
    loadChildren: () => import('../../components/admin/tickets/tickets-routing.module').then(m => m.tickets)
  },
  {
    path: 'categories',
    loadChildren: () => import('../../components/admin/categories/categories-routing.module').then(m => m.category)
  },
  {
    path: 'knowledge',
    loadChildren: () => import('../../components/admin/knowledge/knowledge-routing.module').then(m => m.knowledge)
  },
  {
    path: 'manage-roles',
    loadChildren: () => import('../../components/admin/managr-roles/managr-roles-routing.module').then(m => m.manageRoles)
  },
  {
    path: 'landingpage-settings',
    loadChildren: () => import('../../components/admin/landing-page-settings/landing-page-settings-routing.module').then(m => m.landingPagesettings)
  },
  {
    path: 'envato',
    loadChildren: () => import('../../components/admin/envato/envato-routing.module').then(m => m.envato)
  },
  {
    path: 'app-info/app-purchase-code',
    loadComponent: () => import('../../components/admin/app-info/app-purchase-code/app-purchase-code.component').then(m => m.AppPurchaseCodeComponent),
    data: {
      permission: 'App Purchase Code Access'
    }
  },
  {
    path: 'groups/groups-list',
    loadComponent: () => import('../../components/admin/groups/groups-list/groups-list.component').then(m => m.GroupsListComponent),
    data: {
      permission: 'Groups List Access'
    }
  },
  {
    path: 'payments',
    loadChildren: () => import('../../components/admin/payments/payments-routing.module').then(m => m.payments)
  },
  {
    path: 'projects',
    loadChildren: () => import('../../components/admin/project/project-routing.module').then(m => m.projects)
  },
  {
    path: 'reports',
    loadChildren: () => import('../../components/admin/reports/reports-routing.module').then(m => m.reports)
  },
  {
    path: 'notifications',
    loadChildren: () => import('../../components/admin/notifications/notifications-routing.module').then(m => m.notifications)
  },
  {
    path: 'custom-pages',
    loadChildren: () => import('../../components/admin/custom-pages/custom-pages-routing.module').then(m => m.customPages)
  },
  {
    path: 'holidays',
    loadChildren: () => import('../../components/admin/holidays/holidays-routing.module').then(m => m.holidays)
  },
  {
    path: 'app-setting',
    loadChildren: () => import('../../components/admin//app-setting/app-setting-routing.module').then(m => m.Appsettings)
  },
  {
    path: 'customer',
    loadChildren: () => import('../../components/admin/customer/customer-routing.module').then(m => m.customers)
  },
  {
    path: 'email-template',
    loadChildren: () => import('../../components/admin/email/email-template-routing.module').then(m => m.emailTemplate)
  },
  {
    path: 'languages',
    loadChildren: () => import('../../components/admin/languages/languages-routing.module').then(m => m.language)
  },
  {
    path: 'ticket-view/:id',
    loadComponent: () => import('../../components/admin/ticket-view/ticket-view.component').then(m => m.TicketViewComponent),
    data: {
      permission: true
    },
    canDeactivate: [CanDeactivateGuard]
  },
  {
    path: 'tickethistory/:id',
    loadComponent: () => import('../../components/admin/tickethistory/tickethistory.component').then(m => m.TickethistoryComponent),
    data: {
      permission: true
    }
  },
  {
    path: 'trashed-tickets',
    loadChildren: () => import('../../components/admin/trashed-ticket/trashedticket-routing.module').then(m => m.trashedTickets)
  },
];