import { HttpClient } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable , tap} from 'rxjs';
import { AdminService } from './admin.service';

@Injectable({
  providedIn: 'root'
})
export class AdminProfileService {
  constructor(private http: HttpClient,private adminService: AdminService) { }

  public index(): Observable<any> {
    return this.http.get(`detail/admin/profile`);
  }
  public adminLayout(): Observable<any> {
    return this.http.get(`detail/admin/adminLayout`);
  }

  public changePassword(data:any): Observable<any>{
    return this.http.post(`detail/admin/change-password`,data).pipe(tap(()=>{
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }

  public EditProfile(data:any,http:any): Observable<any>{
    return this.http.post(`detail/admin/profile`,data,http).pipe(
      tap(() => {
        this.adminService.RefreshRquestAdmin$.next();
      })
    );
  }

  public usersettings(data:any): Observable<any>{
    return this.http.get(`detail/admin/usersettings?dark=${data.dark}&user_id=${data.id}`).pipe(
      tap(() => {
        this.adminService.RefreshRquestAdmin$.next();
      })
    );
  }

  public emailonoff(data:any): Observable<any>{
    return this.http.post(`detail/admin/emailonoff`,data).pipe(
      tap(() => {
        this.adminService.RefreshRquestAdmin$.next();
      })
    );
  }
}
