import { HttpClient } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable, tap } from 'rxjs';
import { Unsub } from '../../class/unsub.class';
import { AdminService } from './admin.service';
import { LoaderService } from '../loader.service';

@Injectable({
  providedIn: 'root'
})
export class GeneralSettingsService extends Unsub {
  constructor(private http:HttpClient, private adminService: AdminService, loaderService: LoaderService) {
     /**
     * This code calls the constructor of the parent class in a subclass. 
     * The super() function is used to initialize the parent class and allows access to its properties and methods. 
     * By calling  super(), the subclass can inherit and use the functionality of the parent class.
     **/
super(loaderService);
   }
  public index(): Observable<any>{
    return this.http.get(`detail/admin/general`);
  }

  public store(data:any,http:any): Observable<any>{
    return this.http.post(`detail/admin/general`,data,http).pipe(tap(()=>{
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }

  public urlset(data:any): Observable<any>{
    return this.http.post(`detail/admin/urlset`,data).pipe(tap(()=>{
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }

  public termsurl(): Observable<any>{
    return this.http.get(`detail/admin/termsurl`);
  }

  public frontendStore(data:any): Observable<any>{
    return this.http.post(`detail/admin/colorsetting`,data).pipe(tap(()=>{
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }

  public languages(): Observable<any>{
    return this.http.get(`detail/admin/languages/`);
  }

  public languagesettingstore(data:any): Observable<any>{
    return this.http.post(`detail/admin/languagesetting/`,data).pipe(tap(()=>{
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }

  public datetimeformatstore(data:any): Observable<any>{
    return this.http.post(`detail/admin/datetimeformat/`,data).pipe(tap(()=>{
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }

  public startweekstore(data:any): Observable<any>{
    return this.http.post(`detail/admin/startweek/`,data).pipe(tap(()=>{
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }

  public timezoneupdate(data:any): Observable<any>{
    return this.http.post(`detail/admin/timezoneupdate/`,data).pipe(tap(()=>{
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }

  public footerstore(data:any): Observable<any>{
    return this.http.post(`detail/admin/footer`, data).pipe(tap(()=>{
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }
  public contactUs(data:any): Observable<any>{
    return this.http.post(`detail/admin/contactemail`, data).pipe(tap(()=>{
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }
  public customInvoicesCreate(data:any): Observable<any>{
    return this.http.post(`detail/admin/customInvoices/create`, data).pipe(tap(()=>{
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }
  public customerautologout(data:any): Observable<any>{
    return this.http.post(`detail/admin/customerautologout`, data).pipe(tap(()=>{
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }
  public ticketsettingInvoiceAddress(data:any): Observable<any>{
    return this.http.post(`detail/admin/ticketsetting/invoiceAddress`, data).pipe(tap(()=>{
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }
  public securitySettings(data:any): Observable<any>{
    return this.http.post(`detail/admin/security-settings`, data).pipe(tap(()=>{
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }

  public GlobalSettings(data:any): Observable<any>{
    return this.http.post(`detail/admin/general/register`,data).pipe(tap(()=>{
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }
  public EmailToTicket(data:any): Observable<any>{
    return this.http.post(`detail/admin/general/email-to-ticket`,data).pipe(tap(()=>{
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }
  public EmailToTicketDeleteCloneTicket(data:any): Observable<any>{
    return this.http.post(`detail/admin/general/emailToTicketDeleteCloneTicket`,data).pipe(tap(()=>{
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }

  public kNOWLEDGEENABLESettings(data:any): Observable<any>{
    return this.http.post(`detail/admin/knowledge`,data).pipe(tap(()=>{
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }

  public customerprofiledelete(data:any): Observable<any>{
    return this.http.post(`detail/admin/customerprofiledelete`,data).pipe(tap(()=>{
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }
  public twoFactorAuthSetting(data:any): Observable<any>{
    return this.http.post(`detail/admin/twofactauthsetting`,data).pipe(tap(()=>{
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }
  public profileuser(data:any): Observable<any>{
    return this.http.post(`detail/admin/profileuser`,data).pipe(tap(()=>{
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }

  public getcolorsetting(): Observable<any>{
    return this.http.get(`detail/admin/colorsetting/`);
  }

  public disablestatement(): Observable<any>{
    return this.http.get(`detail/admin/disablestatement/`);
  }

  public logindisable(data:any): Observable<any>{
    return this.http.post(`detail/admin/general/logindisable`, data).pipe(tap(()=>{
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }

}
