import { HttpClient, HttpParams } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable, tap } from 'rxjs';
import { AdminService } from './admin.service';

@Injectable({
  providedIn: 'root'
})
export class IpListService {
  constructor(private http: HttpClient, private adminService: AdminService) { }

  public index(page: number = 1, pageSize: number = 10, filterTerm: string): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
      .set('filter', filterTerm)
    return this.http.get(`detail/admin/ipblocklist`, { params: params });
  }

  public ipblockliststore(data: any): Observable<any> {
    return this.http.post(`detail/admin/ipblocklist/create`, data).pipe(tap(() => {
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }

  public ipblocklistDestroy(id: any): Observable<any> {
    return this.http.get(`detail/admin/ipblocklist/delete/${id}`).pipe(tap(() => {
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }
  public massipblocklistDestroy(data: any): Observable<any> {
    return this.http.post(`detail/admin/ipblocklist/deleteall`, data).pipe(tap(() => {
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }

  public ipblocklistReset(id: any): Observable<any> {
    return this.http.get(`detail/admin/ipblocklist/reset/${id}`).pipe(tap(() => {
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }

  public resetipblock(id: any): Observable<any> {
    return this.http.get(`detail/admin/ipblocklist/${id}`);
  }
}
