import { HttpClient, HttpParams } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Observable, tap } from 'rxjs';
import { AdminService } from './admin.service';

@Injectable({
  providedIn: 'root'
})
export class LiveChatService {
  constructor(private http: HttpClient, private adminService: AdminService) { }

  public livechatTickets(id): Observable<any> {
    return this.http.get(`detail/admin/livechat-tickets?operatorID=${id}`);
  }
  public chatResponses(): Observable<any> {
    return this.http.get(`detail/admin/chat-responses`);
  }
  public solvedchats(): Observable<any> {
    return this.http.get(`detail/admin/solvedchats`);
  }
  public myopened(): Observable<any> {
    return this.http.get(`detail/admin/myopened`);
  }
  public livechatSettings(): Observable<any> {
    return this.http.get(`detail/admin/livechat-settings`);
  }  
  public livechatAllratings(page: number = 1, pageSize: number = 10, filterTerm: string): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
      .set('filter', filterTerm)
    return this.http.get(`detail/admin/livechat-allratings`, { params: params });
  }
  public livechatticket(id: Number, page: number = 1, pageSize: number = 10, filterTerm: string): Observable<any> {
    let params = new HttpParams()
      .set('id', id.toString())
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
      .set('filter', filterTerm)
    return this.http.get(`detail/admin/livechat-tickets`, { params: params });
  }
  public employerRatings(id): Observable<any> {
    return this.http.get(`detail/admin/livechat-employer-ratings/${id}`);
  }
  public deleteFeedback(id, data): Observable<any> {
    return this.http.post(`detail/admin/livechat-delete-feedback/${id}`, data);
  }

  public livechatTicketDelete(): Observable<any> {
    return this.http.get(`detail/admin/livechat-ticket-delete`).pipe(tap(() => {
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }
  public livechatTicketmassdelete(): Observable<any> {
    return this.http.get(`detail/admin/livechat-ticket-massdelete`).pipe(tap(() => {
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }



  //livechat

  public newchat(id): Observable<any> {
    if(id){
      return this.http.get(`detail/admin/livechat?operatorID=${id}`);
    }else{
      return this.http.get(`detail/admin/livechat`);
    }
  }
  public livechatOnlineUsersSave(data: any): Observable<any> {
    return this.http.post(`detail/admin/livechat/online-users-save`, data);
  }

  public livechatEngageConversation(data: any): Observable<any> {
    return this.http.post(`detail/admin/livechat/engage-conversation`, data);
  }

  public livechatConversationleave(id:number | string): Observable<any> {
    return this.http.get(`detail/admin/livechat/conversationleave?id=${id}`).pipe(tap(() => {
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }

  public livechatConversationReassign(data: any): Observable<any> {
    return this.http.post(`detail/admin/livechat/conversation-reassign`, data).pipe(tap(() => {
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }
  public livechatRemoveUserFromUnread(id:number | string): Observable<any> {
    return this.http.get(`detail/admin/livechat/remove-user-from-unread?id=${id}`).pipe(tap(() => {
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }
  public livechatConversationUnread(id:number | string): Observable<any> {
    return this.http.get(`detail/admin/livechat/conversation-unread?id=${id}`).pipe(tap(() => {
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }

  public livechatConversationDelete(id): Observable<any> {
    return this.http.get(`detail/admin/livechat/conversation-delete?unqid=${id}`).pipe(tap(() => {
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }

  public livechatMarkSolved(id:number | string): Observable<any> {
    return this.http.get(`detail/admin/livechat/mark-as-solved?id=${id}`).pipe(tap(() => {
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }

  public livechatLiveChatNotificationsSetting(data: any): Observable<any> {
    return this.http.post(`detail/admin/livechat/live-chat-notifications-setting`, data).pipe(tap(() => {
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }

  public livechatLiveChatNotificationsSound(data: any): Observable<any> {
    return this.http.post(`detail/admin/livechat/live-chat-notifications-sound`, data).pipe(tap(() => {
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }
  public livechatLiveChatIconSound(data: any): Observable<any> {
    return this.http.post(`detail/admin/livechat/live-chat-icon`, data).pipe(tap(() => {
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }

  public livechatLiveChatFlowSettings(data: any): Observable<any> {
    return this.http.post(`detail/admin/livechat/live-chat-flow-settings`, data).pipe(tap(() => {
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }

  public livechatLiveChatFileSettings(data: any): Observable<any> {
    return this.http.post(`detail/admin/livechat/live-chat-file-settings`, data).pipe(tap(() => {
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }

  public livechatLiveChatCustFileupload(data: any): Observable<any> {
    return this.http.post(`detail/admin/livechat/live-chat-cust-fileupload`, data);
  }

  public livechatLiveChatIconSize(data: any): Observable<any> {
    return this.http.post(`detail/admin/livechat/live-chat-icon-size`, data).pipe(tap(() => {
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }
  public livechatLiveChatPosition(data: any): Observable<any> {
    return this.http.post(`detail/admin/livechat/live-chat-position`, data).pipe(tap(() => {
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }
  public livechatLiveChatOfflineSetting(data: any): Observable<any> {
    return this.http.post(`detail/admin/livechat/live-chat-offline-setting`, data).pipe(tap(() => {
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }
  public livechatCannedmessages(): Observable<any> {
    return this.http.get(`detail/admin/livechat/get-cannedmessages`);
  }


  public livechatLivechatCredentials(data: any): Observable<any> {
    return this.http.post(`detail/admin/livechat/livechat-credentials`, data).pipe(tap(() => {
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }
  public livechatssldstore(data: any): Observable<any> {
    return this.http.post(`detail/admin/livechat/livechatssldstore`, data).pipe(tap(() => {
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }
  public livechatLivechatAutosave(data: any): Observable<any> {
    return this.http.post(`detail/admin/livechat/livechat-autosave`, data).pipe(tap(() => {
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }
  public livechatLivechatAutoDelete(data: any): Observable<any> {
    return this.http.post(`detail/admin/livechat/livechatAutoDelete`, data).pipe(tap(() => {
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }
  public LivechatCustWelcomeMsg(data: any): Observable<any> {
    return this.http.post(`detail/admin//livechat-cust-welecome-title`, data).pipe(tap(() => {
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }

  // livechat-flow
  
  public livechatFlow(id): Observable<any> {
    return this.http.get(`detail/admin/livechat-flow/${id}`);
  }
  public livechatFlowTestItOut(id): Observable<any> {
    return this.http.get(`detail/admin/livechat-flow/test-it-out/${id}`);
  }
  public livechatFlowDelete(id): Observable<any> {
    return this.http.get(`detail/admin/livechat-flow/delete/${id}`).pipe(tap(() => {
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }
  public ChatFlowSave(data: any): Observable<any> {
    return this.http.post(`detail/admin/livechat-flow/save`, data).pipe(tap(() => {
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }
  public activeChatFlowSave(data: any): Observable<any> {
    return this.http.post(`detail/admin/livechat-flow/active-save`, data).pipe(tap(() => {
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }
  public ChatAutoFlowSave(data: any): Observable<any> {
    return this.http.post(`detail/admin/livechat-flow/auto-save`, data).pipe(tap(() => {
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }

  // operators
  public operators(): Observable<any> {
    return this.http.get(`detail/admin/operators`);
  }

  public operatorsSingleoperator(id): Observable<any> {
    return this.http.get(`detail/admin/operators/singleoperator/${id}`);
  }
  public operatorsConversationdelete(id): Observable<any> {
    return this.http.get(`detail/admin/operators/conversationdelete/${id}`).pipe(tap(() => {
      this.adminService.RefreshRquestAdmin$.next();
    }));;
  }
  public operatorsMarkasunread(id): Observable<any> {
    return this.http.get(`detail/admin/operators/markasunread/${id}`);
  }
  public operatorsMarkasread(id): Observable<any> {
    return this.http.get(`detail/admin/operators/markasread/${id}`);
  }

  public operatorsBroadcastoperator(data: any): Observable<any> {
    return this.http.post(`detail/admin/operators/broadcastoperator`, data);
  }
  public broadcastoperatorReplyViewed(data: any): Observable<any> {
    return this.http.post(`detail/admin/operators/broadcastoperatorReplyViewed`, data);
  }
  public operatorsAgentbroadcastmessagetyping(data: any): Observable<any> {
    return this.http.post(`detail/admin/operators/agentbroadcastmessagetyping`, data);
  }
  public operatorsGroupbroadcastoperator(data: any): Observable<any> {
    return this.http.post(`detail/admin/operators/groupbroadcastoperator`, data);
  }
  public operatorsGroupconversiondelete(id): Observable<any> {
    return this.http.get(`detail/admin/operators/groupconversiondelete/${id}`).pipe(tap(() => {
      this.adminService.RefreshRquestAdmin$.next();
    }));;
  }
  public operatorsGroupconversion(id): Observable<any> {
    return this.http.get(`detail/admin/operators/groupconversion/${id}`);
  }
  public operatorsGroupconversionstore(id: number, data: any): Observable<any> {
    return this.http.post(`detail/admin/operators/groupconversionstore/${id}`, data);
  }
  public operatorsNotificationsSetting(data: any): Observable<any> {
    return this.http.post(`detail/admin/livechat/operators-notifications-setting`, data).pipe(tap(() => {
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }

  // livechat-notification

  public livechatNotificationsSounds(page: number = 1, pageSize: number = 10, filterTerm: string): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
      .set('filter', filterTerm)
    return this.http.get(`detail/admin/livechat-notifications-sounds`, { params: params });
  }
  public livechatNotificationsSoundsDelete(data): Observable<any> {
    return this.http.post(`detail/admin/livechat-notifications-sounds-delete`, data).pipe(tap(() => {
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }
  public livechatNotificationsMasssoundsDelete(data): Observable<any> {
    return this.http.post(`detail/admin/livechat-notifications-masssounds-delete`, data).pipe(tap(() => {
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }

  
  public livechatFeedbackDropdown(data: any): Observable<any> {
    return this.http.post(`detail/admin/livechat-feedback-dropdown`, data).pipe(tap(() => {
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }
  public securitySettings(data: any): Observable<any> {
    return this.http.post(`detail/admin/security-settings`, data).pipe(tap(() => {
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }

 
  public singlecustdata(id): Observable<any> {
    return this.http.get(`detail/livechat/singlecustdata/${id}`);
  }
  public flow(id): Observable<any> {
    return this.http.get(`detail/livechat/flow/${id}`);
  }
  public runSurver(): Observable<any> {
    return this.http.get(`detail/livechat/run-surver`);
  }
  public livechatPort(): Observable<any> {
    return this.http.get(`detail/livechat/livechat-port`);
  }
  public customerdata(data: any): Observable<any> {
    return this.http.post(`detail/livechat/customerdata`, data);
  }
  public broadcastMessage(data: any): Observable<any> {
    return this.http.post(`detail/livechat/broadcast-message`, data);
  }
  public broadcastMessageTyping(data: any): Observable<any> {
    return this.http.post(`detail/livechat/broadcast-message-typing`, data);
  }
  public userSeenMessagesIndication(data: any): Observable<any> {
    return this.http.post(`detail/livechat/user-seen-messages-indication`, data);
  }
  public liveChatImageUpload(data: any): Observable<any> {
    return this.http.post(`detail/livechat/live-chat-image-upload`, data);
  }
  public liveChatImageRemove(data: any): Observable<any> {
    return this.http.post(`detail/livechat/live-chat-image-remove`, data);
  }
  public customerOnline(data: any): Observable<any> {
    return this.http.post(`detail/livechat/customer-online`, data);
  }
  public removeCustomerOnline(data: any): Observable<any> {
    return this.http.post(`detail/livechat/remove-customer-online`, data);
  }
  public livechatDownloadFile(data: any): Observable<any> {
    return this.http.post(`detail/livechat/livechat-download-file`, data);
  }



}
