import { Injectable } from '@angular/core';
import { Observable, tap } from 'rxjs';
import { HttpClient, HttpHeaders, HttpParams } from '@angular/common/http';
import moment from 'moment-timezone';
import { AdminService } from '../admin/admin.service';

@Injectable({
  providedIn: 'root',
})
export class CustomersService {
  constructor(private http: HttpClient, private adminService: AdminService) { }
  httpOptions = {
    headers: new HttpHeaders({
      Accept: 'application/json',
    }),
  };
  public header(): Observable<any> {
    return this.http.get(`detail/header`);
  }
  public checkLogin() {
    return this.http.get(`detail/customer/checkLoginAdmin`, { observe: 'response' });
  }
  public getcustomerLogin(): Observable<any> {
    return this.http.get(`detail/customer/login`);
  }
  public scoialLogin(callback) {
    return this.http.get(`detail/customer/login/${callback}`);
  }
  public verifytoken(token) {
    return this.http.get(`detail/customer/user/verify/${token}`);
  }
  public customerLogin(data: any): Observable<any> {
    return this.http.post(`detail/customer/login`, data);
  }
  public changePswd(data: any): Observable<any> {
    return this.http.post(`detail/customer/change-password`, data);
  }
  public customeremailchange(data: any): Observable<any> {
    return this.http.post(`detail/customer/customeremailchange`, data);
  }
  public customermobilechange(data: any): Observable<any> {
    return this.http.post(`detail/customer/profile/verifyOTP`, data).pipe(
      tap(() => {
        this.adminService.RefreshRquestAdmin$.next();
      })
    );
  }
  public customernewemailstore(data: any): Observable<any> {
    return this.http.post(`detail/customer/customernewemailstore`, data);
  }
  public emailchangeotpverify(email: string, data: any): Observable<any> {
    return this.http.post(`detail/customer/emailchangeotpverify/${email}`, data);
  }
  public customeremailupdate(email:string): Observable<any> {
    return this.http.get(`detail/customer/customeremailupdate/${email}`);
  }
  public getregister(): Observable<any> {
    return this.http.get(`detail/customer/register`);
  }
  public customerRegister(data: any): Observable<any> {
    return this.http.post(`detail/customer/register`, data);
  }
  public forgotPassword(data: any): Observable<any> {
    return this.http.post(`detail/customer/forgotpassword`, data);
  }
  public getResetData(token: any): Observable<any> {
    return this.http.get(`detail/customer/${token}/reset-password`);
  }
  public resetPsw(data: any): Observable<any> {
    return this.http.post(`detail/customer/reset-password`, data);
  }
  public customerLogout(data: any): Observable<any> {
    return this.http.post(`detail/customer/logout`, data);
  }
  public deleteaccount(id, data: any): Observable<any> {
    return this.http.post(`detail/customer/deleteaccount/${id}`, data);
  }

  public index(): Observable<any> {
    return this.http.get(`detail/admin/customer/create`);
  }
  public checkBusinessHours() {
    return this.http.get(`detail/customer/businesshours`);
  }

  public dashboardData(page: number = 1, pageSize: number = 10, filterTerm: string): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
      .set('filter', filterTerm)

    return this.http.get(`detail/customer/dashboardcontroller`, { params: params });
  }
  public showTicket(id: string, page: number = 1, pageSize: number = 6): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())

    return this.http.get(`detail/customer/ticket/view/${id}`, { params: params });
  }
  public TicketReopen(ticketid, data: any): Observable<any> {
    return this.http.post(`detail/customer/closed/${ticketid}`, data).pipe(
      tap(() => {
        this.adminService.RefreshRquestAdmin$.next();
      })
    );
  }
  public replyTicket(ticketId, data: any): Observable<any> {
    return this.http.post(`detail/customer/ticket/${ticketId}`, data).pipe(
      tap(() => {
        this.adminService.RefreshRquestAdmin$.next();
      })
    );
  }

  public updateTicket(id, data: any): Observable<any> {
    return this.http.post(`detail/customer/ticket/editcomment/${id}`, data).pipe(
      tap(() => {
        this.adminService.RefreshRquestAdmin$.next();
      })
    );
  }

  public RandomPassWord() {

    const prefix: any = Array(8).fill("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz~!@-#$").map(function (x) {
      return x[Math.floor(Math.random() * x.length)];
    }).join('');
    const integer = Array(8).fill("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz~!@-#$")
      .map(function (x) {
        return x[Math.floor(Math.random() * x.length)];
      }).join('');
    return prefix + integer;
  }

  public customersData(): Observable<any> {
    return this.http.get(`detail/admin/customer/`);
  }

  public customersshow(id: any): Observable<any> {
    return this.http.get(`detail/admin/customer/${id}`);
  }

  public profile(): Observable<any> {
    return this.http.get(`detail/customer/profile`);
  }

  public profilesetup(data: any, http: any): Observable<any> {
    return this.http.post(`detail/customer/profile`, data, http).pipe(
      tap(() => {
        this.adminService.RefreshRquestAdmin$.next();
      })
    );
  }
  public verifytwofactor(email): Observable<any> {
    return this.http.get(`detail/customer/verifytwofactor/${email}`);
  }
  public google2faauthlogin(data): Observable<any> {
    return this.http.post(`detail/customer/google2faauthlogin`, data);
  }
  public google2faauth(email): Observable<any> {
    return this.http.get(`detail/customer/google2faauth/${email}`);
  }
  public sendotpPhoneUpdate(data): Observable<any> {
    return this.http.post(`detail/customer/profile/sendotp`, data);
  }
  public resendotp(email): Observable<any> {
    return this.http.get(`detail/customer/resendotp/${email}`);
  }
  public otpverify(data): Observable<any> {
    return this.http.post(`detail/customer/verifytwofactor`, data);
  }
  public emailtwofactorcustomerset(data: any): Observable<any> {
    return this.http.post(`detail/customer/emailtwofactorcustomerset`, data, this.httpOptions).pipe(
      tap(() => {
        this.adminService.RefreshRquestAdmin$.next();
      })
    );
  }
  public google2faauthnew(data: any): Observable<any> {
    return this.http.post(`detail/customer/google2faauthnew`, data, this.httpOptions).pipe(
      tap(() => {
        this.adminService.RefreshRquestAdmin$.next();
      })
    );
  }
  public google2faotpverify(data: any): Observable<any> {
    return this.http.post(`detail/customer/google2faotpverify`, data, this.httpOptions).pipe(
      tap(() => {
        this.adminService.RefreshRquestAdmin$.next();
      })
    );
  }

  public imageremove(res: any, id: any): Observable<any> {
    return this.http
      .post(`detail/customer/image/remove/${id}`, res)
      .pipe(
        tap(() => {
          this.adminService.RefreshRquestAdmin$.next();
        })
      );
  }

  public TicketControllercreate(): Observable<any> {
    return this.http.get(`detail/customer/ticket`);
  }

  public TicketControllerStore(res: any): Observable<any> {
    return this.http.post(`detail/customer/ticket`, res).pipe(
      tap(() => {
        this.adminService.RefreshRquestAdmin$.next();
      })
    );
  }

  public customerChangeCurrency(data: any): Observable<any> {
    return this.http.post(`detail/customer/changeCurrency`, data).pipe(
      tap(() => {
        this.adminService.RefreshRquestAdmin$.next();
      })
    );
  }
  public TicketControllerdestroy(id: any): Observable<any> {
    return this.http.get(`detail/customer/ticket/delete/${id}`).pipe(
      tap(() => {
        this.adminService.RefreshRquestAdmin$.next();
      })
    );
  }
  public customerTicketdeleteAll(data: any): Observable<any> {
    return this.http.post(`detail/customer/ticket/delete/tickets`, data).pipe(tap(() => {
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }
  public markasread(data: any): Observable<any> {
    return this.http.post(`detail/customer/mark-as-read`, data).pipe(tap(() => {
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }

  public markAllAsRead(data: any): Observable<any> {
    return this.http.post(`detail/customer/markAsRead`, data).pipe(tap(() => {
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }

  public notificationView(id): Observable<any> {
    return this.http.get(`detail/customer/notification/${id}`);
  }

  public allNotification(pageCount: number = 1, status: any, notifysearch: string): Observable<any> {
    return this.http.get(`detail/customer/notification`, {
      params: {
        'page': pageCount,
        'notifysearch': notifysearch,
        'status': status
      }
    });
  }
  public notifysearch(data: any): Observable<any> {
    return this.http.post(`detail/customer/notifysearch`, data).pipe(tap(() => {
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }
  public notifystatus(data: any): Observable<any> {
    return this.http.post(`detail/customer/notifystatus`, data).pipe(tap(() => {
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }
  public deletenotify(data: any): Observable<any> {
    return this.http.post(`detail/customer/notify/delete`, data).pipe(tap(() => {
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }

  public ticketstoreMedia(data: any, http: any): Observable<any> {
    return this.http.post(`detail/customer/imageupload`, data, http)
  }

  public ticketstoreMediaComment(id: any, data: any): Observable<any> {
    return this.http.post(`detail/customer/ticket/imageupload/${id}`, data)
  }
  // rating

  public rating(ticketId): Observable<any> {
    return this.http.get(`detail/rating/${ticketId}`);
  }
  public ticketRating(data): Observable<any> {
    return this.http.post(`detail/ticket/rating`, data).pipe(tap(() => {
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }
  public custtwiliosetting(data): Observable<any> {
    return this.http.post(`detail/customer/custtwiliosetting`, data).pipe(tap(() => {
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }

  public cnotificationsreading(): Observable<any> {
    return this.http.get(`detail/customer/cnotificationsreading`);
  }

  public badgecount(): Observable<any> {
    return this.http.get(`detail/customer/cbadgecount`);
  }

  public markallnotify(data: any): Observable<any> {
    return this.http.post(`detail/customer/markallnotify`, data).pipe(tap(() => {
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }

  public markNotification(data: any): Observable<any> {
    return this.http.post(`detail/customer/mark-as-read`, data).pipe(tap(() => {
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }

  // custom pages
  public pages(): Observable<any> {
    return this.http.get(`detail/admin/pages`);
  }

  public usersettings(data): Observable<any> {
    return this.http.post(`detail/customer/custsettings`, data).pipe(
      tap(() => {
        this.adminService.RefreshRquestAdmin$.next();
      })
    );
  }

  getUTCFromTimezone(timezone: string): any {
   
    const offsetInMinutes = moment.tz(timezone).utcOffset();
    // Convert the offset to hours and format it as UTC+/-X
    const sign = offsetInMinutes >= 0 ? '+' : '-';
    const offsetInHours = Math.abs(offsetInMinutes) / 60;
    const formattedOffset = `UTC${sign}${offsetInHours < 10 ? '0' : ''}${offsetInHours}`;

    return formattedOffset;
  }
  
  public quotations(page: number = 1, pageSize: number = 10, filterTerm: string): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
      .set('filter', filterTerm)

    return this.http.get(`detail/customer/quotations`, { params: params });
  }
  public transactions(page: number = 1, pageSize: number = 10, filterTerm: string): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
      .set('filter', filterTerm)

    return this.http.get(`detail/customer/transactions`, { params: params });
  }
  public customInvoices(page: number = 1, pageSize: number = 10, filterTerm: string): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
      .set('filter', filterTerm)

    return this.http.get(`detail/customer/custominvoice`, { params: params });
  }
  public refunds(page: number = 1, pageSize: number = 10, filterTerm: string): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
      .set('filter', filterTerm)

    return this.http.get(`detail/customer/refunds`, { params: params });
  }
  
  public refundRequest(id): Observable<any> {
    return this.http.get(`detail/customer/refundView/${id}`);
  }

  public refundRequestspostComment(data): Observable<any> {
    return this.http.post(`detail/customer/requestRefund/postComment`, data).pipe(
      tap(() => {
        this.adminService.RefreshRquestAdmin$.next();
      })
    );
  }
  public requestRefund$(data): Observable<any> {
    return this.http.post(`detail/customer/requestRefund`, data).pipe(
      tap(() => {
        this.adminService.RefreshRquestAdmin$.next();
      })
    );
  }
  public invoiceCheckout$(data): Observable<any> {
    return this.http.post(`detail/customer/invoiceCheckout`, data).pipe(
      tap(() => {
        this.adminService.RefreshRquestAdmin$.next();
      })
    );
  }
  
  public customInvoice(id): Observable<any> {
    return this.http.get(`detail/customer/invoice/${id}`);
  }
  public StripeSuccess(): Observable<any> {
    return this.http.get(`detail/customer/invoicePayment/StripeSuccess`);
  }
  public PaypalSuccess(): Observable<any> {
    return this.http.get(`detail/customer/invoicePayment/PaypalSuccess`);
  }
  public StripeError(id): Observable<any> {
    return this.http.get(`detail/customer/invoicePayment/StripeSuccess/${id}`);
  }
  public PaypalError(id): Observable<any> {
    return this.http.get(`detail/customer/invoicePayment/PaypalError/${id}`);
  }
  public customInvoicePay(id): Observable<any> {
    return this.http.get(`detail/customer/customInvoice/pay/${id}`);
  }
}
