import { Injectable } from '@angular/core';
import { HttpClient, HttpParams } from '@angular/common/http';
import { Observable, of, tap } from 'rxjs';
import { AdminService } from './admin/admin.service';
import { Router } from '@angular/router';
import { ToastrService } from 'ngx-toastr';
import moment from 'moment-timezone';

@Injectable({
  providedIn: 'root',
})
export class GuestService {
  constructor(private http: HttpClient, private adminService: AdminService, private router: Router, private toastr: ToastrService) { }
  public addExternalScript(val){
    if(val){
          // Use a regular expression to match HTML tags
      var tagRegex = /<([^>\s]+)([^>]*)>([\s\S]*?)<\/\1>|<([^>\s]+)([^>]*)>|<[^>]+>/g;

      // Extract the tag name and attributes from each tag
      var matches = val.matchAll(tagRegex);

      // Loop through the matches
      for (const match of matches) {
        // Extract the tag name and attributes
        var tagName = (match[1] || match[3] || '').toLowerCase();
        var attributes = (match[2] || match[4] || '').trim();
        var innerHTML = match[3] || '';
        // Create a new element based on the tag name
        var newElement = document.createElement(tagName);
        newElement.classList.add('customexternalchart');
        // Parse attributes and set them for the new element
        attributes?.split(/\s+/).forEach(function (attribute) {
          var [key, value] = attribute?.split('=');
          if (key && value) {
            // Remove quotes around attribute values
            value = value.replace(/^['"]|['"]$/g, '');
            newElement.setAttribute(key, value);
          }
        });

        // Set the inner HTML for the new element
        newElement.innerHTML = innerHTML;

        // Log or process each new element
        document.body.append(newElement);

      }
    }
  }
  public home(): Observable<any> {
    return this.http.get(`detail/`);
  }
  public getannouncments(): Observable<any> {
    return this.http.get(`detail/getannouncments/`);
  }
  public header(): Observable<any> {
    return this.http.get(`detail/header`);
  }
  public knowledge(): Observable<any> {
    return this.http.get(`detail/knowledge`);
  }
  public faq(): Observable<any> {
    return this.http.get(`detail/faq`);
  }
  public faqcategorypage(id: string | null): Observable<any> {
    return this.http.get(`detail/faq/${id}`);
  }
  public getcontactus(): Observable<any> {
    return this.http.get(`detail/contact-us`);
  }
  public contactus(data: any): Observable<any> {
    return this.http.post(`detail/contact-us`, data).pipe(
      tap(() => {
        this.adminService.RefreshRquestAdmin$.next();
      })
    );
  }
  public ratingTicket(ticketid): Observable<any> {
    return this.http.get(`detail/rating/${ticketid}`);
  }
  public starrating(id, data): Observable<any> {
    return this.http.post(`detail/rating/star/${id}`, data).pipe(
      tap(() => {
        this.adminService.RefreshRquestAdmin$.next();
      })
    );
  }
  public ticketRating(data: any): Observable<any> {
    return this.http.post(`detail/ticket/rating`, data).pipe(
      tap(() => {
        this.adminService.RefreshRquestAdmin$.next();
      })
    );
  }

  public allsetting(): Observable<any> {
    return this.http.get(`detail/allsetting`);
  }

  // Submit ticket start
  public openTicket(): Observable<any> {
    return this.http.get(`detail/guest/openticket`);
  }
  public openTicketwithotp(data: any): Observable<any> {
    return this.http.post(`detail/guest/openticket`, data).pipe(
      tap(() => {
        this.adminService.RefreshRquestAdmin$.next();
      })
    );
  }
  public openTicketwithoutotp(data: any): Observable<any> {
    return this.http.post(`detail/guest/openticketnootp`, data).pipe(
      tap(() => {
        this.adminService.RefreshRquestAdmin$.next();
      })
    );
  }
  public ticketOtpDetails(id: any): Observable<any> {
    return this.http.get(`detail/guest/ticket-view/details/${id}`);
  }
  public sendotp(data: any): Observable<any> {
    return this.http
      .post(`detail/guest/ticket-view/sendotp`, data)
      .pipe(
        tap(() => {
          this.adminService.RefreshRquestAdmin$.next();
        })
      );
  }
  public verifyotp(data: any): Observable<any> {
    return this.http.post(`detail/verifyotp`, data).pipe(
      tap(() => {
        this.adminService.RefreshRquestAdmin$.next();
      })
    );
  }
  public verifyguestotp(data: any): Observable<any> {
    return this.http.post(`detail/guest/verifyguestotp`, data).pipe(
      tap(() => {
        this.adminService.RefreshRquestAdmin$.next();
      })
    );
  }
  public emailsvalidate(data: any): Observable<any> {
    return this.http.post(`detail/emailsvalidate`, data).pipe(
      tap(() => {
        this.adminService.RefreshRquestAdmin$.next();
      })
    );
  }

  public articleView(id: any): Observable<any> {
    return this.http.get(`detail/article/${id}`);
  }
  public categoryView(id: any): Observable<any> {
    return this.http.get(`detail/category/${id}`);
  }
  public pages(id: any): Observable<any> {
    return this.http.get(`detail/page/${id}`);
  }
  public searchArt(data: any): Observable<any> {
    return this.http.post(`detail/search`, data).pipe(
      tap(() => {
        this.adminService.RefreshRquestAdmin$.next();
      })
    );
  }

  public ticketDetailsView(id: any, page: number = 1, pageSize: number = 6): Observable<any> {
    let params = new HttpParams()
      .set('page', page.toString())
      .set('per_page', pageSize.toString())
    return this.http.get(`detail/guest/ticket-view/${id}`, { params: params });
  }
  public showpdf(id: any): Observable<any> {
    return this.http.get(`detail/customer/ticket/pdfmake/${id}`);
  }
  public guestreplay(id: any, data: any): Observable<any> {
    return this.http.post(`detail/guest/ticket/${id}`, data).pipe(
      tap(() => {
        this.adminService.RefreshRquestAdmin$.next();
      })
    );
  }
  public updatereplay(id: any, data: any): Observable<any> {
    return this.http.post(`detail/guestticket/editcomment/${id}`, data).pipe(
      tap(() => {
        this.adminService.RefreshRquestAdmin$.next();
      })
    );
  }
  public reopenTicket(id: any, data: any): Observable<any> {
    return this.http.post(`detail/guest/closed/${id}`, data).pipe(
      tap(() => {
        this.adminService.RefreshRquestAdmin$.next();
      })
    );
  }

  public guestLayout(): Observable<any> {
    return this.http.get(`detail/guestLayout`);
  }
  public arayobj(): Observable<any> {
    return of([
      { id: 1, name: 'some' }
    ]);
  }

  // submit ticket end
  public storemedia(data: any, http: any): Observable<any> {
    return this.http.post(`detail/guest/storemedia`, data, http);
  }

  public likedislike(data: any): Observable<any> {
    return this.http.post(`detail/likedislike`, data).pipe(tap(() => {
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }

  public recentImagDelete(data: any,): Observable<any> {
    return this.http.post(`detail/guest/image/delete/${data.id}`, data).pipe(tap(() => {
      this.adminService.RefreshRquestAdmin$.next();
    }));
  }
  // error apis
  public error404(): Observable<any> {
    return this.http.get(`detail/error404`);
  }
  public error503(): Observable<any> {
    return this.http.get(`detail/error503`);
  }
  public error429(): Observable<any> {
    return this.http.get(`detail/error429`);
  }
  public getCapchaType(): Observable<any> {
    return this.http.get(`detail/getCapchaType`);
  }
  public ipblockupdate(data: any): Observable<any> {
    return this.http.post(`detail/ipblock/update`, data);
  }
  public getimage(storage_disk, imagePath): Observable<any> {
    return this.http.get(`detail/getimage/${storage_disk}/${imagePath}`);
  }
  
  public emailtoticketdownload(id, imagePath): Observable<any> {
    return this.http.get(`detail/emailtoticketdownload/${id}/${imagePath}`,{ responseType: 'blob' });
  }
  
  public image(id, imagePath): Observable<any> {
    return this.http.get(`detail/image/${id}/${imagePath}`,{ responseType: 'blob' });
  }
  public emiltoticketimage(id, imagePath): Observable<any> {
    return this.http.get(`detail/emailtoticket/${id}/${imagePath}`,{ responseType: 'blob' });
  }

  getUTCFromTimezone(timezone: string): any {
   
    const offsetInMinutes = moment.tz(timezone).utcOffset();

    // Convert the offset to hours and format it as UTC+/-X
    const sign = offsetInMinutes >= 0 ? '+' : '-';
    const offsetInHours = Math.abs(offsetInMinutes) / 60;
    const formattedOffset = `UTC${sign}${offsetInHours < 10 ? '0' : ''}${offsetInHours}`;

    return formattedOffset;
  }
}
