import { ElementRef, Injectable } from '@angular/core';
import { BehaviorSubject } from 'rxjs';

@Injectable({
  providedIn: 'root',
})
export class LivechatSocketService {
  private dynamicListSubject = new BehaviorSubject<ElementRef | undefined>(undefined);
  private updateData = new BehaviorSubject<string>(null); 
  
  triggerSidemenuUpdate() {
    this.updateData.next('true');
  }
  getUpdatedState() {
    return this.updateData.asObservable();
  }
  // Method to update dynamicList
  setDynamicList(dynamicList: ElementRef) {
    this.dynamicListSubject.next(dynamicList);
  }

  // Expose observables to components
  getDynamicListObservable() {
    return this.dynamicListSubject.asObservable();
  }
  
  formatTime(inputTime: any) {
    const date = new Date(inputTime);

    const hours = date.getHours();
    const minutes = date.getMinutes();
    const ampm = hours >= 12 ? ' PM' : ' AM';
    const formattedHours = hours % 12 === 0 ? 12 : hours % 12;
    const formattedMinutes = minutes < 10 ? '0' + minutes : minutes;

    const formattedTime = `${formattedHours}:${formattedMinutes}${ampm}`;
    return formattedTime;
  }


}
