import { Injectable } from '@angular/core';
import { ToastrService } from 'ngx-toastr';
import { BehaviorSubject } from 'rxjs';

@Injectable({
  providedIn: 'root'
})
export class LoaderService {
  private loaderCounter: number = 0;
  private loaderSubject: BehaviorSubject<boolean> = new BehaviorSubject<boolean>(false);

  constructor(private toastr : ToastrService){}
  showLoader() {
    this.loaderCounter++;
    if (this.loaderCounter === 1) {
      this.loaderSubject.next(true);
    }
  }

  clearLoader() {
    this.loaderCounter = 0;
  }
  hideLoader() {
    this.loaderCounter--;
    if (this.loaderCounter === 0) {
      this.loaderSubject.next(false);
    }
  }

  getLoaderState() {
    return this.loaderSubject.asObservable();
  }

  downloadFile(url: string, filename: string, callback: Function) {
    const xhr = new XMLHttpRequest();
    xhr.open('GET', url, true);
    xhr.responseType = 'blob';

    xhr.onload = () => {
      if (xhr.status === 200) {
        const blob = xhr.response;
        const link = document.createElement('a');
        link.href = window.URL.createObjectURL(blob);
        link.download = filename;
        link.click();

        // Trigger the callback function after download is complete
        callback();

        // Revoke the object URL to avoid memory leaks
        window.URL.revokeObjectURL(link.href);
      } else {
        this. toastr.error(xhr.statusText)
        // Trigger the callback function after download is complete
        callback();
        console.error('Download failed:', xhr.statusText);
      }
    };

    xhr.onerror = (error) => {
      console.error('Download error:', error);
    };

    xhr.send();
  }
}
