<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\User;
use App\Models\Countries;
use Illuminate\Support\Facades\Hash;
use Spatie\Permission\Models\Role;
use App\Models\Ticket\Category;
use App\Models\Apptitle;
use App\Models\Footertext;
use App\Models\usersettings;
use App\Models\Seosetting;
use App\Models\Pages;
use Auth;
use Illuminate\Support\Str;
use App\Imports\UserImport;
use Maatwebsite\Excel\Facades\Excel;
use App\Models\Department;
use App\Models\Ticket\Ticket;
use App\Models\ticketassignchild;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Support\Facades\Validator;
use Image;
use File;
use Illuminate\Support\Facades\Schema;
use laravelLara\infoinst\Jobs\MailSend;
use App\Models\senduserlist;
use Jenssegers\Agent\Agent;
use Torann\GeoIP\Facades\GeoIP;
use App\Models\EmployeeActivity;
use Illuminate\Support\Facades\Log;

class AgentCreateController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $this->authorize('Employee Access');

        $country = Countries::all();
        $data['countries'] = $country;

        $user = User::with('permissions', 'roles');

        $searchTerm = $request['filter'] ?? null;
        $perPage    = $request['per_page'] ?? 15;
        $page       = $request['page'] ?? 1;

        if ($searchTerm) {
            $user->where(function ($query) use ($searchTerm) {
                $columns = Schema::getColumnListing('users');
                foreach ($columns as $column) {
                    $query->orWhere($column, 'LIKE', "%{$searchTerm}%");
                }
                $query->orWhereHas('permissions', function ($query) use ($searchTerm) {
                    $query->where('name', 'LIKE', $searchTerm . '%');
                });
                $query->orWhereHas('roles', function ($query) use ($searchTerm) {
                    $query->where('name', 'LIKE', $searchTerm . '%');
                });
            });
        }
        $items = $user->paginate($perPage);
        $data['queryList'] = $items;

        $allroles = Role::get();
        $data['roles'] = $allroles;
        $categories = Category::whereIn('display', ['ticket', 'all'])->where('status', '1')->get();
        $data['categories'] = $categories;

        $departments = Department::where('status', '1')->get();
        $data['departments'] = $departments;

        $admin = User::with('usetting')->findOrFail(Auth::user()->id);
        $data['authId'] =  $admin->id;
        $role = Role::where('name', $admin->getRoleNames()[0])->get();
        foreach ($role as $roles) {
            $data['permissions'] = $roles->getPermissionNames();
        }

        return $data;
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $this->authorize('Employee Create');
        $country = Countries::all();
        $data['countries'] = $country;

        $allroles = Role::get();
        $data['roles'] = $allroles;

        $departments = Department::where('status', '1')->get();
        $data['departments'] = $departments;


        return $data;
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->authorize('Employee Create');
        $request->validate([
            'firstname' => 'required|string|max:255',
            'lastname' => 'required|string|max:255',
            'empid' => 'required|max:255|unique:users',
            'email' => 'required|string|email|max:255|unique:users',
            'role' => 'required',
            'password' => 'required|string|min:8',
        ]);
        if ($request->phone) {
            $request->validate([
                'phone' => 'numeric',
            ]);
        }
        if ($request->hasFile('image')) {
            $request->validate([
                'image' => 'mimes:jpeg,jpg,png|required|max:5120',
            ]);
        }
        $user = User::create([
            'firstname' => Str::ucfirst($request->input('firstname')),
            'lastname' => Str::ucfirst($request->input('lastname')),
            'empid' => Str::upper($request->empid),
            'email' => $request->email,
            'status' => '1',
            'password' => Hash::make($request->password),
            'skills' => $request->skills,
            'phone' => $request->phone,
            'country' => $request->country,
            'timezone' => $request->timezone,
            'departments' => $request->department,
            'dashboard' => $request->dashboard,
            'image' => null,
            'verified' => '1',

        ]);

        $users = User::find($user->id);
        $users->name = $user->firstname . ' ' . $user->lastname;
        $users->languagues = $request->languages;
        $users->darkmode = setting('DARK_MODE');


        if ($request->hasFile('image')) {
            $file = $request->file('image');
            $fileArray = array('image' => $file);
            $rules = array(
                'image' => 'mimes:jpeg,jpg,png|required|max:5120' // max 10000kb	
            );
            // Now pass the input and rules into the validator	
            $validator = Validator::make($fileArray, $rules);
            if ($validator->fails()) {
                return response()->json(['error' => 'Please check the format and size of the file.']);
            } else {

                $image_name = time() . '.' . $file->getClientOriginalExtension();
                $provider = storage()->provider;
                $existprovider = existprovider($user->storage_disk);
                if ($existprovider)
                    $existprovider->provider::delete('/uploads/profile' . "/" . $user->image);
                $upload =  $provider::uploadprofile($file, $image_name);
                if ($upload)
                    $users->update(['image' => $image_name, 'storage_disk' => storage()->storage_disk]);
                else
                    return response()->json(['error' => 'Image upload failed please try again.']);
            }
        }

        $users->update();

        $user->assignRole([$request->role]);


        $usersetting = new usersettings();
        $usersetting->users_id = $users->id;
        $usersetting->emailnotifyon = '1';
        $usersetting->save();



        $ticketData = [
            'userpassword' => $request->password,
            'username' => $user->firstname . ' ' . $user->lastname,
            'useremail' => $user->email,
            'url' => url('/admin'),
        ];

        try {
            dispatch((new MailSend($user->email, 'employee_send_registration_details', $ticketData)));
        } catch (\Exception $e) {
            $geolocation = GeoIP::getLocation(request()->getClientIp());
            $agent = new Agent();
            $activity = new EmployeeActivity();
            $activity->user_id = Auth::user()->id;
            $activity->activity_type = 'Creted an employee' . ' ' . $users->name;
            $activity->ip_address = $geolocation->ip;
            $activity->browser = $agent->browser();
            $activity->device = $agent->device();
            $activity->save();
            return response()->json(['code' => 200, 'success' => 'A new employee was successfully added.'], 200);
        }
        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Creted an employee' . ' ' . $users->name;
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();
        return response()->json(['code' => 200, 'success' => 'A new employee was successfully added.'], 200);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $this->authorize('Employee Edit');
        $id = decrypt($id);
        // $this->authorize('Employee Edit');
        $user = User::with('roles', 'permissions')->where('id', $id)->first();
        $data['user'] = $user;

        $country = Countries::all();
        $data['countries'] = $country;

        $roles = Role::get();
        $data['roles'] = $roles;

        $departments = Department::where('status', '1')->get();
        $data['departments'] = $departments;

        $admin = User::with('usetting')->findOrFail(Auth::user()->id);
        $data['authId'] =  $admin->id;

        $allroles = Role::get();
        $data['roles'] = $allroles;
        $categories = Category::whereIn('display', ['ticket', 'all'])->where('status', '1')->get();
        $data['categories'] = $categories;

        $departments = Department::where('status', '1')->get();
        $data['departments'] = $departments;
        return $data;
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->authorize('Employee Edit');

        $id = decrypt($id);
        $employee = User::find($id);


        $request->validate([
            'firstname' => 'required|string|max:255',
            'lastname' => 'required|string|max:255',
            'role' => 'required',
        ]);
        if ($request->phone) {
            $request->validate([
                'phone' => 'numeric',
            ]);
        }
        if ($request->email == $employee->email) {
            $request->validate([
                'email' => 'required|string|email|max:255',
            ]);
        } else {
            $request->validate([
                'email' => 'required|string|email|max:255|unique:users',
            ]);
        }
        if ($request->empid == $employee->empid) {
            $request->validate([
                'empid' => 'required|max:255',
            ]);
        } else {
            $request->validate([
                'empid' => 'required|max:255||unique:users',
            ]);
        }

        if ($request->hasFile('image')) {
            $request->validate([
                'image' => 'mimes:jpeg,jpg,png|required|max:5120',
            ]);
        }
        $user = User::with('roles')->where('id', $id)->findOrFail($id);
        if (Auth::user()->id == 1) {
            $editallow = 'allowed';
        } elseif ($user->id == Auth::user()->id || $user->getRoleNames()[0] != 'superadmin') {
            $editallow = 'allowed';
        } else {
            $editallow = 'notallowed';
        }
        if ($editallow == 'allowed') {
            $user->firstname = Str::ucfirst($request->input('firstname'));
            $user->lastname = Str::ucfirst($request->input('lastname'));
            if ($request->email != $employee->email) {
                $user->email = $request->email;
            }
            if ($request->empid != $employee->empid) {

                $user->empid = Str::upper($request->empid);
            }
            $user->languagues = $request->languages;
            $user->skills = $request->skills;
            $user->phone = $request->phone;
            $user->country = $request->country;
            $user->timezone = $request->timezone;
            $user->departments = $request->department;
            $user->dashboard = $request->dashboard;


            $user->status = $request->input('status');

            $user->update();

            if ($request->input('profileRemoved') != 'null' && $request->input('profileRemoved') != 'undefined') {
                $user->image = null;
                $user->update();
            }
            $user->name = $user->firstname . ' ' . $user->lastname;

            if ($request->hasFile('image')) {
                $file = $request->file('image');
                $fileArray = array('image' => $file);
                $rules = array(
                    'image' => 'mimes:jpeg,jpg,png|required|max:5120' // max 10000kb	
                );
                // Now pass the input and rules into the validator	
                $validator = Validator::make($fileArray, $rules);
                if ($validator->fails()) {
                    return response()->json(['error' => 'Please check the format and size of the file.']);
                } else {
                    $image_name = time() . '.' . $file->getClientOriginalExtension();
                    $provider = storage()->provider;
                    $existprovider = existprovider($user->storage_disk);
                    if ($existprovider)
                        $existprovider->provider::delete('/uploads/profile' . "/" . $user->image);
                    $upload =  $provider::uploadprofile($file, $image_name);
                    if ($upload)
                        $user->update(['image' => $image_name, 'storage_disk' => storage()->storage_disk]);
                    else
                        return response()->json(['error' => 'Image upload failed please try again.']);
                }
            }
            $user->update();
        } else {
            return  response()->json(['error' => lang('You are not allowed to update this profile.', 'alerts')], 500);
        }

        if ($employee->id == Auth::user()->id && $request->role != $user->getRoleNames()[0]) {
            return response()->json(['code' => 500, 'error', 'You are not eligible to update your role.', 'alerts'], 500);
        } else {
            if (!empty($user->getRoleNames()[0])) {
                $user->removeRole($user->getRoleNames()[0]);
            }
            $user->assignRole($request->role);
        }
        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Updated employee profile of' . ' ' . $employee->name;
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['code' => 200, 'success' => 'The employee’s profile was successfully updated.'], 200);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $this->authorize('Employee Delete');
        $id = decrypt($id);
        $user = User::where('id', $id)->findOrFail($id);
        if (Auth::user()->id == 1) {
            $editallow = 'allowed';
        } elseif ($user->id == Auth::user()->id || $user->getRoleNames()[0] != 'superadmin') {
            $editallow = 'allowed';
        } else {
            $editallow = 'notallowed';
        }

        if ($editallow == 'allowed') {
            // to remove myassignid and selfassignid when destroying employee
            $assigneeid = ticketassignchild::where('toassignuser_id', $id)->get();
            if ($assigneeid->all() != null) {
                $ticketData = [
                    'myassignuser_id' => null,
                    'selfassignuser_id' => null,
                ];

                $ticketchildList = ticketassignchild::all();
                $groupedByValue = $ticketchildList->groupBy('ticket_id');
                $single = $groupedByValue->filter(function (Collection $groups) {
                    return $groups->count() == 1;
                });
                foreach ($single as $ind) {
                    foreach ($ind as $i) {
                        if ($i->ticket_id == $assigneeid[0]->ticket_id) {
                            Ticket::where('id', $i->ticket_id)->update($ticketData);
                        }
                    }
                }
            }
            $user->usetting()->delete();
            $custnotifications = senduserlist::where('touser_id', $user->id)->get();
            foreach ($custnotifications as $custnotification) {
                $custnotifycount = senduserlist::where('mail_id', $custnotification->mail_id)->count();
                if ($custnotifycount == 1) {
                    $custnotification->sendmaildata->delete();
                }
                $custnotification->delete();
            }
            // $user->usercustomsetting()->delete();

            $user->delete();

            $geolocation = GeoIP::getLocation(request()->getClientIp());
            $agent = new Agent();
            $activity = new EmployeeActivity();
            $activity->user_id = Auth::user()->id;
            $activity->activity_type = 'Deleted an employee - ' . ' ' . $user->name;
            $activity->ip_address = $geolocation->ip;
            $activity->browser = $agent->browser();
            $activity->device = $agent->device();
            $activity->save();

            if (webSocketCheck()) {
                try {
                    event(new \App\Events\ConversationEvent(dbname(), null, null, null, null, null, 'tableDataReload', null));
                } catch (\Exception $e) {
                    Log::error('Error dispatching WebSocket event: ' . $e->getMessage());
                }
            }

            return response()->json(['success' => 'The employee was successfully deleted.']);
        } else {
            return response()->json(['success' => 'You are not allowed to delete this employee.'], 500);
        }
    }

    public function usermassdestroy(Request $request)
    {
        $this->authorize('Employee Delete');

        $student_id_arrays = $request->input('id');

        $student_id_array = array_map(function ($encryptedValue) {
            return decrypt($encryptedValue);
        }, $student_id_arrays);

        $customers = User::whereIn('id', $student_id_array)->where('id', '!=', 1)->get();

        foreach ($customers as $user) {
            // to remove myassignid and selfassignid when destroying employee
            $assigneeid = ticketassignchild::where('toassignuser_id', $user->id)->get();
            if ($assigneeid->all() != null) {

                $ticketData = [
                    'myassignuser_id' => null,
                    'selfassignuser_id' => null,
                ];

                $ticketchildList = ticketassignchild::all();
                $groupedByValue = $ticketchildList->groupBy('ticket_id');
                $single = $groupedByValue->filter(function (Collection $groups) {
                    return $groups->count() == 1;
                });
                foreach ($single as $ind) {
                    foreach ($ind as $i) {
                        if ($i->ticket_id == $assigneeid[0]->ticket_id) {
                            Ticket::where('id', $i->ticket_id)->update($ticketData);
                        }
                    }
                }
            }

            $user->usetting()->delete();
            $custnotifications = senduserlist::where('touser_id', $user->id)->get();
            foreach ($custnotifications as $custnotification) {
                $custnotifycount = senduserlist::where('mail_id', $custnotification->mail_id)->count();
                if ($custnotifycount == 1) {
                    $custnotification->sendmaildata->delete();
                }
                $custnotification->delete();
            }

            $user->delete();

            $geolocation = GeoIP::getLocation(request()->getClientIp());
            $agent = new Agent();
            $activity = new EmployeeActivity();
            $activity->user_id = Auth::user()->id;
            $activity->activity_type = 'Deleted multiple employees';
            $activity->ip_address = $geolocation->ip;
            $activity->browser = $agent->browser();
            $activity->device = $agent->device();
            $activity->save();
        }
        return response()->json(['success' => 'The employee was successfully deleted.']);
    }

    public function status(Request $request, $id)
    {
        $this->authorize('Employee Status');
        $id = decrypt($id);

        $calID = User::find($id);

        if (Auth::user()->id == 1) {
            $editallow = 'allowed';
        } elseif ($user->id == Auth::user()->id || $user->getRoleNames()[0] != 'superadmin') {
            $editallow = 'allowed';
        } else {
            $editallow = 'notallowed';
        }

        if ($editallow == 'allowed') {
            $calID->status = $request->status;
            $calID->save();

            $geolocation = GeoIP::getLocation(request()->getClientIp());
            $agent = new Agent();
            $activity = new EmployeeActivity();
            $activity->user_id = Auth::user()->id;
            $activity->activity_type = 'Changed employee status';
            $activity->ip_address = $geolocation->ip;
            $activity->browser = $agent->browser();
            $activity->device = $agent->device();
            $activity->save();

            return response()->json(['code' => 200, 'success' => 'Updated successfully'], 200);
        } else {
            return response()->json(['code' => 500, 'error' => lang('You are not allowed to update this profile.', 'alerts')], 500);
        }
    }

    public function userimportindex()
    {
        $this->authorize('Employee Importlist');
        $title = Apptitle::first();
        $data['title'] = $title;

        $footertext = Footertext::first();
        $data['footertext'] = $footertext;

        $seopage = Seosetting::first();
        $data['seopage'] = $seopage;

        $post = Pages::all();
        $data['page'] = $post;

        return $data;
    }

    /**
     * @return \Illuminate\Support\Collection
     */
    public function usercsv(Request $req)
    {
        $this->authorize('Employee Importlist');
        if ($req->hasFile('file')) {
            $validator = Validator::make(
                $req->all(),
                [

                    'file' => 'required|file|mimes:xlsx,csv,txt',
                ],
                [
                    'file.mimes' => 'The file must be a file of type: xlsx, csv.',
                ]
            );
            if ($validator->fails()) {
                return redirect()->back()->withErrors($validator)->withInput();
            }

            $file = $req->file('file')->store('import');

            // $import = Excel::import(new UserImport, $file);
            $import = new UserImport;
            Excel::import($import, $file);

            $importedUsers = User::whereIn('empid', collect($import->getImportedUserEmpIds()))->get();
            foreach ($importedUsers as $user) {
                $usersetting = new Usersettings();
                $usersetting->users_id = $user->id;
                $usersetting->emailnotifyon = '1';
                $usersetting->save();
            }



            if ($import->hasData) {
                $geolocation = GeoIP::getLocation(request()->getClientIp());
                $agent = new Agent();
                $activity = new EmployeeActivity();
                $activity->user_id = Auth::user()->id;
                $activity->activity_type = 'Imported employees';
                $activity->ip_address = $geolocation->ip;
                $activity->browser = $agent->browser();
                $activity->device = $agent->device();
                $activity->save();
                return response()->json(['code' => 200, 'success' => 'The employee list was imported successfully.'], 200);
            } else {
                return response()->json(['error' => 'The imported file does not contain any data.']);
            }

            $geolocation = GeoIP::getLocation(request()->getClientIp());
            $agent = new Agent();
            $activity = new EmployeeActivity();
            $activity->user_id = Auth::user()->id;
            $activity->activity_type = 'Imported employees';
            $activity->ip_address = $geolocation->ip;
            $activity->browser = $agent->browser();
            $activity->device = $agent->device();
            $activity->save();
            return response()->json(['code' => 200, 'success' => 'The employee list was imported successfully.'], 200);
        } else {
            return response()->json(['error' => 'Please select file to import data of Employee.']);
        }
    }

    public function employeepasswordreset(Request $req)
    {
        $this->authorize('Employee Edit');

        $id = decrypt($req->sprukopasswordreset_id);
        $req->validate([
            'resetpassword' => 'required|string|min:8',
        ]);
        $passwordchanging = User::find($id);
        if (Auth::user()->id == 1) {
            $editallow = 'allowed';
        } elseif ($passwordchanging->id == Auth::user()->id || $passwordchanging->getRoleNames()[0] != 'superadmin') {
            $editallow = 'allowed';
        } else {
            $editallow = 'notallowed';
        }

        if ($editallow == 'allowed') {
            $passwordchanging->password = Hash::make($req->resetpassword);
            $passwordchanging->update();

            $geolocation = GeoIP::getLocation(request()->getClientIp());
            $agent = new Agent();
            $activity = new EmployeeActivity();
            $activity->user_id = Auth::user()->id;
            $activity->activity_type = 'Changed password of' . ' ' . $passwordchanging->name;
            $activity->ip_address = $geolocation->ip;
            $activity->browser = $agent->browser();
            $activity->device = $agent->device();
            $activity->save();

            return response()->json(['success' => 'The password has been successfully changed!'], 200);
        } else {
            return response()->json(['code' => 500, 'error' => 'You are not allowed to change password.'], 500);
        }
    }
}
