<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;


use App\Models\Apptitle;
use App\Models\Languages;
use App\Models\Footertext;
use App\Models\Seosetting;
use App\Models\Pages;
use Jenssegers\Agent\Agent;
use Torann\GeoIP\Facades\GeoIP;
use App\Models\EmployeeActivity;
use Illuminate\Support\Facades\Auth;

class ApptitleController extends Controller
{
	public function index()
	{
		$this->authorize('General Setting Access');

		$title = Apptitle::first();
		$data['title'] = $title;

		$footertext = Footertext::first();
		$data['footertext'] = $footertext;

		$seopage = Seosetting::first();
		$data['seopage'] = $seopage;

		$post = Pages::all();
		$data['page'] = $post;

		$languages = Languages::withCount(['translates' => function ($query) {
			$query->where('value', null);
		}])->get();
		$data['languages'] = $languages;
		$data['setting'] = response([
			'default_lang' => setting('default_lang'),
			'cust_mobile_update' => setting('cust_mobile_update'),
			'IMAP_STATUS' => setting('IMAP_STATUS'),
			'Customer_email_two_fact' => setting('Customer_email_two_fact'),
			'Customer_google_two_fact' => setting('Customer_google_two_fact'),
			'Employe_email_two_fact' => setting('Employe_email_two_fact'),
			'Employe_google_two_fact' => setting('Employe_google_two_fact'),
			'MAINTENANCE_MODE' => setting('MAINTENANCE_MODE'),
			'date_format' => setting('date_format'),
			'FAQ_ENABLE' => setting('FAQ_ENABLE'),
			'CONTACT_ENABLE' => setting('CONTACT_ENABLE'),
			'time_format' => setting('time_format'),
			'start_week' => setting('start_week'),
			'default_timezone' => setting('default_timezone'),
			'FILE_UPLOAD_MAX' => setting('FILE_UPLOAD_MAX'),
			'contact_form_mail' => setting('contact_form_mail'),
			'customer_inactive_notify' => setting('customer_inactive_notify'),
			'customer_inactive_notify_date' => setting('customer_inactive_notify_date'),
			'customer_inactive_week_date' => setting('customer_inactive_week_date'),
			'guest_inactive_notify' => setting('guest_inactive_notify'),
			'guest_inactive_notify_date' => setting('guest_inactive_notify_date'),
			'guest_inactive_week_date' => setting('guest_inactive_week_date'),
			'SPRUKOADMIN_P' => setting('SPRUKOADMIN_P'),
			'SPRUKOADMIN_C' => setting('SPRUKOADMIN_C'),
			'DARK_MODE' => setting('DARK_MODE'),
			'REGISTER_POPUP' => setting('REGISTER_POPUP'),
			'REGISTER_DISABLE' => setting('REGISTER_DISABLE'),
			'login_disable' => setting('login_disable'),
			'GOOGLEFONT_DISABLE' => setting('GOOGLEFONT_DISABLE'),
			'FORCE_SSL' => setting('FORCE_SSL'),
			'KNOWLEDGE_ENABLE' => setting('KNOWLEDGE_ENABLE'),
			'ENVATO_ON' => setting('ENVATO_ON'),
			'PROFILE_USER_ENABLE' => setting('PROFILE_USER_ENABLE'),
			'article_count' => setting('article_count'),
			'only_social_logins' => setting('only_social_logins'),
			'defaultlogin_on' => setting('defaultlogin_on'),
			'sidemenu_icon_style' => setting('sidemenu_icon_style'),
			'cust_email_update' => setting('cust_email_update'),
			'cust_profile_delete_enable' => setting('cust_profile_delete_enable'),
			'terms_url' => setting('terms_url'),
			'login_disable_statement' => setting('login_disable_statement'),
			'theme_color' => setting('theme_color'),
			'theme_color_dark' => setting('theme_color_dark'),
			'customer_inactive_auto_logout_time' => setting('customer_inactive_auto_logout_time'),
			'customer_inactive_auto_logout' => setting('customer_inactive_auto_logout'),
			'admin_users_inactive_auto_logout_time' => setting('admin_users_inactive_auto_logout_time'),
			'admin_users_inactive_auto_logout' => setting('admin_users_inactive_auto_logout'),
			'inspectDisable' => setting('inspectDisable'),
			'selectDisabled' => setting('selectDisabled'),
			'emp_google_translate' => setting('emp_google_translate'),
			'cust_google_translate' => setting('cust_google_translate'),
			'cust_email_verification' => setting('cust_email_verification'),
            'companyName' => setting('companyName'),
            'addressLine1' => setting('addressLine1'),
            'addressLine2' => setting('addressLine2'),
            'cityName' => setting('cityName'),
            'stateName' => setting('stateName'),
            'zipPostalCode' => setting('zipPostalCode'),
            'countryName' => setting('countryName'),
            'taxName' => setting('taxName'),
            'taxId' => setting('taxId'),
            'taxPercent' => setting('taxPercent'),
            'customInvoiceId' => setting('customInvoiceId'),
		]);

		// cronjob command setup
		if (strpos($_SERVER['SERVER_SOFTWARE'], 'Hostinger') !== false || strpos($_SERVER['SERVER_SOFTWARE'], 'Cloudways') !== false || strpos($_SERVER['SERVER_SOFTWARE'], 'AAPanel') !== false) {
			$croncommanddata = '/usr/bin/php ' . base_path() . '/artisan schedule:run >> /dev/null 2>&1';
		} elseif (strpos($_SERVER['SERVER_SOFTWARE'], 'CloudPanel') !== false) {
			$croncommanddata = '/usr/bin/php ' . base_path() . '/artisan schedule:run >> /dev/null 2>&1';
		} elseif ($_SERVER['SERVER_NAME'] == 'localhost' && $_SERVER['DOCUMENT_ROOT'] == 'C:/xampp/htdocs') {
			$croncommanddata = 'php artisan schedule:work';
		} else {
			$croncommanddata = '/usr/local/bin/php ' . base_path() . '/artisan schedule:run >> /dev/null 2>&1';
		}

		$data['croncommanddata'] = $croncommanddata;
		return $data;
	}

	public function ImageUploadupdate(Request $request)
	{
		if (!$request->hasFile('image') && !$request->file('image')->isValid()) {
			return response()->json('{"error": "Plase Provide an image"}');
		}
		try {
			$imageName = $request->file('image')->hashName();
			Storage::disk('local')->put($imageName, file_get_contents($request->file('image')));
			return response()->json($imageName);
		} catch (\Exception $e) {
			return response()->json($e);
		}
	}



	public function store(Request $request)
	{
		$request->validate([
			'title' => 'required',

		]);
		$calID = ['id' => $request->id];

		$calldetails = [
			'title' => $request->title,
			'checkbox' => $request->input('checkbox'),
		];

		// light logo upload
		if ($files = $request->file('image')) {

			$request->validate([
				'image' => 'required|mimes:jpg,jpeg,png,svg|max:5120',
			]);

			//delete old file
			$testiimage = Apptitle::find($request->id);
			$imagepath =   public_path() . '/uploads/logo/logo/' . $testiimage->image;
			if (\File::exists($imagepath)) {
				\File::delete($imagepath);
			}

			//insert new file
			$destinationPath = public_path() . '/uploads/logo/logo/'; // upload path
			$profileImage = date('YmdHis') . "." . $files->getClientOriginalExtension();
			$files->move($destinationPath, $profileImage);
			$calldetails['image'] = "$profileImage";
		}

		// dark logo upload
		if ($files = $request->file('image1')) {

			$request->validate([
				'image1' => 'required|mimes:jpg,jpeg,png,svg|max:5120',
			]);

			//delete old file
			$testiimage1 = Apptitle::find($request->id);
			$imagepath1 =   public_path() . '/uploads/logo/darklogo/' . $testiimage1->image1;
			if (\File::exists($imagepath1)) {
				\File::delete($imagepath1);
			}

			//insert new file
			$destinationPath = public_path() . '/uploads/logo/darklogo/'; // upload path
			$profileImage = date('YmdHis') . "." . $files->getClientOriginalExtension();
			$files->move($destinationPath, $profileImage);
			$calldetails['image1'] = "$profileImage";
		}

		// Dark-Icon upload 
		if ($files = $request->file('image2')) {

			$request->validate([
				'image2' => 'required|mimes:jpg,jpeg,png,svg|max:5120',
			]);

			//delete old file
			$testiimage2 = Apptitle::find($request->id);
			$imagepath2 =   public_path() . '/uploads/logo/icon/' . $testiimage2->image2;
			if (\File::exists($imagepath2)) {
				\File::delete($imagepath2);
			}

			//insert new file
			$destinationPath = public_path() . '/uploads/logo/icon/'; // upload path
			$profileImage = date('YmdHis') . "." . $files->getClientOriginalExtension();
			$files->move($destinationPath, $profileImage);
			$calldetails['image2'] = "$profileImage";
		}

		// Light-Icon upload
		if ($files = $request->file('image3')) {

			$request->validate([
				'image3' => 'required|mimes:jpg,jpeg,png,svg|max:5120',
			]);

			//delete old file
			$testiimage3 = Apptitle::find($request->id);
			$imagepath3 =   public_path() . '/uploads/logo/darkicon/' . $testiimage3->image3;
			if (\File::exists($imagepath3)) {
				\File::delete($imagepath3);
			}

			//insert new file
			$destinationPath = public_path() . '/uploads/logo/darkicon/'; // upload path
			$profileImage = date('YmdHis') . "." . $files->getClientOriginalExtension();
			$files->move($destinationPath, $profileImage);
			$calldetails['image3'] = "$profileImage";
		}

		// Upload Favicon uploa	 
		if ($files = $request->file('image4')) {

			$request->validate([
				'image4' => 'required|mimes:jpg,jpeg,png,svg|max:5120',
			]);

			//delete old file
			$testiimage4 = Apptitle::find($request->id);
			$imagepath4 =   public_path() . '/uploads/logo/favicons/' . $testiimage4->image4;
			if (\File::exists($imagepath4)) {
				\File::delete($imagepath4);
			}


			//insert new file
			$destinationPath = public_path() . '/uploads/logo/favicons/'; // upload path
			$profileImage = date('YmdHis') . "." . $files->getClientOriginalExtension();
			$files->move($destinationPath, $profileImage);
			$calldetails['image4'] = "$profileImage";
		}

		$callaction = Apptitle::updateOrCreate(
			['id' => $calID],
			$calldetails
		);

		$geolocation = GeoIP::getLocation(request()->getClientIp());
		$agent = new Agent();
		$activity = new EmployeeActivity();
		$activity->user_id = Auth::user()->id;
		$activity->activity_type = 'Updated App Title & Logos section';
		$activity->ip_address = $geolocation->ip;
		$activity->browser = $agent->browser();
		$activity->device = $agent->device();
		$activity->save();

		return response()->json(['success' => 'Updated successfully']);
	}


	public function bannerpage()
	{
		$this->authorize('Banner Access');
		$basic = Apptitle::first();

		$title = Apptitle::first();
		$data['title'] = $title;

		$footertext = Footertext::first();
		$data['footertext'] = $footertext;

		$seopage = Seosetting::first();
		$data['seopage'] = $seopage;

		$post = Pages::all();
		$data['page'] = $post;

		return $basic;
	}

	public function bannerstore(Request $request)
	{
		$this->authorize('Banner Access');
		$request->validate([
			'searchtitle' => 'required|string|max:255',

		]);

		if ($request->searchsub) {
			$request->validate([
				'searchsub' => 'string|max:255',

			]);
		}
		$calID = ['id' => $request->id];
		$calldetails = [
			'searchtitle' => $request->searchtitle,
			'searchsub' => $request->searchsub,

		];

		$callaction = Apptitle::updateOrCreate(['id' => $calID], $calldetails);

		$geolocation = GeoIP::getLocation(request()->getClientIp());
		$agent = new Agent();
		$activity = new EmployeeActivity();
		$activity->user_id = Auth::user()->id;
		$activity->activity_type = 'Updated Banner Section.';
		$activity->ip_address = $geolocation->ip;
		$activity->browser = $agent->browser();
		$activity->device = $agent->device();
		$activity->save();

		return response()->json(['success' => 'Updated successfully']);
	}

	public function footerstore(Request $request)
	{

		$request->validate([
			'copyright' => 'required',

		]);
		$calID = ['id' => $request->id];
		$calldetails = [

			'copyright' => $request->copyright,

		];
		$callaction = Footertext::updateOrCreate(
			['id' => $calID],
			$calldetails
		);

		$geolocation = GeoIP::getLocation(request()->getClientIp());
		$agent = new Agent();
		$activity = new EmployeeActivity();
		$activity->user_id = Auth::user()->id;
		$activity->activity_type = 'Updated Footer Section.';
		$activity->ip_address = $geolocation->ip;
		$activity->browser = $agent->browser();
		$activity->device = $agent->device();
		$activity->save();

		return response()->json(['success' => 'Updated successfully']);
	}


	public function logodelete(Request $request)
	{
		$logo = Apptitle::find($request->id);
		if ($request->logo == 'logo1') {
			if ($logo->image != null) {
				$imagepath =   public_path() . '/uploads/logo/logo/' . $logo->image;
				if (\File::exists($imagepath)) {
					\File::delete($imagepath);
				}
			}
			$logo->image = null;
			$logo->update();
		}
		if ($request->logo == 'logo2') {
			if ($logo->image1 != null) {
				$imagepath =   public_path() . '/uploads/logo/darklogo/' . $logo->image1;
				if (\File::exists($imagepath)) {
					\File::delete($imagepath);
				}
			}
			$logo->image1 = null;
			$logo->update();
		}
		if ($request->logo == 'logo3') {
			if ($logo->image2 != null) {
				$imagepath =   public_path() . '/uploads/logo/icon/' . $logo->image2;
				if (\File::exists($imagepath)) {
					\File::delete($imagepath);
				}
			}
			$logo->image2 = null;
			$logo->update();
		}
		if ($request->logo == 'logo4') {
			if ($logo->image3 != null) {
				$imagepath =   public_path() . '/uploads/logo/darkicon/' . $logo->image3;
				if (\File::exists($imagepath)) {
					\File::delete($imagepath);
				}
			}
			$logo->image3 = null;
			$logo->update();
		}
		if ($request->logo == 'logo5') {
			if ($logo->image4 != null) {
				$imagepath =   public_path() . '/uploads/logo/favicons/' . $logo->image4;
				if (\File::exists($imagepath)) {
					\File::delete($imagepath);
				}
			}
			$logo->image4 = null;
			$logo->update();
		}
		$geolocation = GeoIP::getLocation(request()->getClientIp());
		$agent = new Agent();
		$activity = new EmployeeActivity();
		$activity->user_id = Auth::user()->id;
		$activity->activity_type = 'Deleted logo.';
		$activity->ip_address = $geolocation->ip;
		$activity->browser = $agent->browser();
		$activity->device = $agent->device();
		$activity->save();

		return response()->json(['success' => 'Deleted successfully', 200]);
	}
}
