<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\callaction;
use Jenssegers\Agent\Agent;
use Torann\GeoIP\Facades\GeoIP;
use App\Models\EmployeeActivity;
use Auth;

class CalltoactionController extends Controller
{
    public function index()
    {

        $this->authorize('Call To Action Access');

        $callaction = callaction::first();
        if ($callaction->image) {
            $conversionsDisk = $callaction->storage_disk ?? 'public';
            $provider = existprovider($conversionsDisk)->provider;
            $imageUrl = $provider::getimage('uploads/callaction/' . $callaction->image);
            // Only set the "profileimage" attribute if it's not already set
            if (!isset($callaction['profileimage'])) {
                $callaction['profileimage'] = $imageUrl;
            }
        }
        $data['callaction'] = $callaction;
        $data['setting'] = response()->json([
            'ENVATO_ON' => setting('ENVATO_ON'),
            'FILE_UPLOAD_MAX' => setting('FILE_UPLOAD_MAX'),
            'MAX_FILE_UPLOAD' => setting('MAX_FILE_UPLOAD'),
            'FILE_UPLOAD_TYPES' => setting('FILE_UPLOAD_TYPES'),
            'TICKET_CHARACTER' => setting('TICKET_CHARACTER'),
            'USER_FILE_UPLOAD_TYPES' => setting('USER_FILE_UPLOAD_TYPES'),
        ]);

        return $data;
    }

    public function store(Request $request)
    {
        $this->authorize('Call To Action Access');

        $request->validate([
            'title' => 'required|string|max:255',
            'buttonname' => 'required|string|max:255',
            'buttonurl' => 'required|string|max:255|url',

        ]);
        if ($request->subtitle) {
            $request->validate([
                'subtitle' => 'max:255'
            ]);
        }

        if ($request->file('image')) {
            $request->validate([
                'image' => 'required|mimes:jpg,jpeg,png,svg|max:10240',

            ]);
        }
        $calID = ['id' => $request->id];
        $calldetails = [
            'title' => $request->title,
            'subtitle' => $request->subtitle,
            'buttonname' => $request->buttonname,
            'buttonurl' => $request->buttonurl,
            'callcheck'  => $request->has('callcheck') ? 'on' : 'off',
        ];

        if ($request->calltoactionRemoved) {
            $callimage = callaction::find($request->calltoactionRemoved);
            $imagepath =   public_path() . "" . '/uploads/callaction/' . $callimage->image;
            if (\File::exists($imagepath)) {
                \File::delete($imagepath);
            }
            $callimage->image = null;
            $callimage->save();
        }
        if ($files = $request->file('image')) {

            $callimage = callaction::find($request->id);
            $provider  = existprovider($callimage->storage_disk ?? 'public')->provider;
            $provider::delete('/uploads/featurebox/' . $callimage->image);
            //insert new file
            $profileImage = date('YmdHis') . "." . $files->getClientOriginalExtension();
            $provider = storage()->provider;
            $provider::uploadImage($files, '/uploads/callaction/', $profileImage);
            $calldetails['image'] = $profileImage;
            $calldetails['storage_disk'] = storage()->storage_disk;
        } else {
            // If no new image, retain the existing image
            $callimage = callaction::find($request->id);
            if ($callimage) {
                $calldetails['image'] = $callimage->image;
                $calldetails['storage_disk'] = $callimage->storage_disk;
            }
        }

        $callaction = callaction::updateOrCreate(['id' => $calID], $calldetails);

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Updated Call Action Section.';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['success' => 'Updated successfully']);
    }

    public function destroyImage($id)
    {
        $this->authorize('Call To Action Access');
        $callaction = callaction::find($id);
        // $imagepath =   public_path() . "" . '/uploads/callaction/' . $callimage->image;
        // if (\File::exists($imagepath)) {
        //     \File::delete($imagepath);
        // }

        $provider  = existprovider($callaction->storage_disk ?? 'public')->provider;
        $provider::delete('/uploads/callaction/' . $callaction->image);
        $callaction->image = null;
        $callaction->save();

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Deleted callaction image.';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();
        
        return response()->json(['success' => 'Deleted successfully.']);
    }
}
