<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Customcssjs;
use Jenssegers\Agent\Agent;
use Torann\GeoIP\Facades\GeoIP;
use App\Models\EmployeeActivity;
use Illuminate\Support\Facades\Auth;

class CustomcssjsController extends Controller
{
    public function index()
    {
        $this->authorize('Custom JS & CSS Access');

        $data['CUSTOMJS'] = customcssjs('CUSTOMJS');
        $data['CUSTOMCSS'] = customcssjs('CUSTOMCSS');

        return $data;
    }

    /**
     * Frontend Settings Save/Update.
     *
     * @return \Illuminate\Http\Response
     */
    public function customcssjs(Request $request)
    {

        $data = $request->only(['customcss', 'customjs']);

        $this->updateSettings($data);

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Updated Custom CSS & JS.';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();
        
        return response()->json(['success'=> 'Updated Successfully']);
    }


    public function customchat(){
        $this->authorize('Custom Chat Access');
        $data['CUSTOMCHAT'] = customcssjs('CUSTOMCHAT');
        $data['CUSTOMCHATUSER'] = customcssjs('CUSTOMCHATUSER');
        $data['CUSTOMCHATENABLE'] = customcssjs('CUSTOMCHATENABLE');

        return $data;
    }
    /**
     * Frontend Settings Save/Update.
     *
     * @return \Illuminate\Http\Response
     */
    public function customchats(Request $request)
    {

        $data = $request->only(['customchat']);
        $data['CUSTOMCHATENABLE']  =  $request->has('CUSTOMCHATENABLE') ? 'enable' : 'disable';
        $data['CUSTOMCHATUSER']  =  $request->CUSTOMCHATUSER == 'public' ? 'public' : 'user';

        $this->updateSettings($data);
        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Updated customchats';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();
        
        return response()->json(['success'=> 'Updated Successfully']);
    }


    /**
     *  Settings Save/Update.
     *
     * @return \Illuminate\Http\Response
     */
    private function updateSettings($data)
    {

        foreach($data as $name => $val){
        	$setting = Customcssjs::where('name', $name);
        	if( $setting->exists() )
        		$setting->first()->update(['value' => $val]);
        }

    }
}
