<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Pages;
use App\Models\Customfield;
use App\Models\User;
use Spatie\Permission\Models\Role;
use Auth;
use Illuminate\Support\Facades\Schema;
use Jenssegers\Agent\Agent;
use Torann\GeoIP\Facades\GeoIP;
use App\Models\EmployeeActivity;

class CustomfieldController extends Controller
{
    public function index(Request $request)
    {

        $this->authorize('CustomField Access');

        $post = Pages::all();
        $data['page'] = $post;

        $user = User::with('usetting')->findOrFail(Auth::user()->id);
        $role = Role::where('name', $user->getRoleNames()[0])->get();
        foreach ($role as $roles) {
            $data['permissions'] = $roles->getPermissionNames();
        }


        $customfields = Customfield::latest();
        $searchTerm = $request['filter'] ?? null;
        $perPage    = $request['per_page'] ?? 15;
        $page       = $request['page'] ?? 1;

        if ($searchTerm) {
            $customfields->where(function ($query) use ($searchTerm) {
                $columns = Schema::getColumnListing('customfields');
                foreach ($columns as $column) {
                    $query->orWhere($column, 'LIKE', "%{$searchTerm}%");
                }
            });
        }
        $items = $customfields->paginate($perPage);
        $data['queryList'] = $items;

        return $data;
    }

    public function storeupdate(Request $request)
    {
        $sprukofieldtype = $request->sprukofieldtype;

        if ($sprukofieldtype == 'select' || $sprukofieldtype == 'checkbox' || $sprukofieldtype == 'radio') {
            $required = 'required';
        } else {
            $required = '';
        }
        $request->validate(
            [
                'sprukofieldname' => 'required',
                'display' => 'required',
                'optionsfields' => $required,

            ],
            [

                'sprukofieldname.required' => 'Your Label Field Name is Required', // custom message
                'display.required' => 'Your View On Field is Required',
                'optionsfields.required' => 'Options field is required when field type is select, checkbox, or radio',
            ]

        );


        $customfieldId = $request->customfieldopen_id;
        $customfield =  [
            'fieldtypes' => $request->sprukofieldtype,
            'fieldnames' => $request->sprukofieldname,
            'fieldprivacy' => $request->privacyfields,
            'status' => $request->status,
            'fieldrequired' => $request->requiredfields,
            'fieldoptions' => $request->optionsfields,
            'displaytypes' => $request->display,

        ];

        $custom = Customfield::updateOrCreate(['id' => $customfieldId], $customfield);

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = $customfieldId ? 'updated a custom field' : 'Created a custom field';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        $message = $customfieldId ? 'Customfield updated successfully.' : 'Customfield created successfully.';

        return response()->json(['success' => $message], 200,);
    }

    public function edit($id)
    {
        $this->authorize('CustomField Edit');
        $customfieldfind = Customfield::findOrFail($id);
        return response()->json($customfieldfind, 200);
    }

    public function destroy($id)
    {
        $this->authorize('CustomField Delete');

        $customfielddelete = Customfield::findOrFail($id);
        $customfielddelete->delete();
        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Deleted a custom field';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();
        return response()->json(['success' => 'Deleted successfully'], 200);
    }

    public function destroyall(Request $request)
    {
        $this->authorize('CustomField Delete');

        $id_array = $request->input('id');

        $customfields = Customfield::whereIn('id', $id_array)->get();

        foreach ($customfields as $customfield) {
            $customfield->delete();
        }
        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Deleted custom fields';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();
        return response()->json(['success' => 'Deleted successfully']);
    }
    public function status(Request $request, $id)
    {
        $this->authorize('CustomField Edit');

        $customfieldfind = Customfield::find($id);
        $customfieldfind->status = $request->status;
        $customfieldfind->save();
        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Changed status of custom field';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        return response()->json(['code' => 200, 'success' => 'Updated Successfully'], 200);
    }
}
