<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\IPLIST;
use App\Models\User;
use Spatie\Permission\Models\Role;
use Auth;
use Illuminate\Support\Facades\Schema;
use Jenssegers\Agent\Agent;
use Torann\GeoIP\Facades\GeoIP;
use App\Models\EmployeeActivity;

class IpblockController extends Controller
{
    public function index(Request $request)
    {
        $iplists = IPLIST::latest();

        $searchTerm = $request['filter'] ?? null;
        $perPage    = $request['per_page'] ?? 15;
        $page       = $request['page'] ?? 1;

        if ($searchTerm) {
            $iplists->where(function ($query) use ($searchTerm) {
                $columns = Schema::getColumnListing('i_p_l_i_s_t_s');
                foreach ($columns as $column) {
                    $query->orWhere($column, 'LIKE', "%{$searchTerm}%");
                }
            });
        }
        $items = $iplists->paginate($perPage);
        $data['queryList'] = $items;

        $user = User::with('usetting')->findOrFail(Auth::user()->id);
        $role = Role::where('name', $user->getRoleNames()[0])->get();
        foreach ($role as $roles) {
            $data['permissions'] = $roles->getPermissionNames();
        }

        return $data;
    }

    public function show($id)
    {

        $ip = IPLIST::find($id);

        return response()->json($ip);
    }


    public function store(Request $request)
    {

        $request->validate([
            'ip' => 'required|ip',
            'types' => 'required',

        ]);

        $ipId = $request->IP_id;
        $ipdata =  [
            'ip' => $request->ip,
            'types' => $request->types,

        ];


        $ipdtaa = IPLIST::updateOrCreate(['id' => $ipId], $ipdata);

        $ipdataupdate = IPLIST::find($ipdtaa->id);
        if ($ipdataupdate->entrytype != 'Auto') {
            $ipdataupdate->entrytype = 'Manual';
        }
        $ipdataupdate->update();

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = $ipId ? 'Updated Ip address' : 'created Ip address';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();

        $message = $ipId ? 'IP address updated successfully.' : 'IP address created successfully.';
        return response()->json(['code' => 200, 'success' => $message, 'data' => $ipdtaa], 200);
    }

    public function destroy($id)
    {
        $ipdelete = IPLIST::find($id);
        $ipdelete->delete();
        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Deleted an IP address';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();
        return response()->json(['success' => 'The IP address has been successfully removed.']);
    }


    public function allipblocklistdelete(Request $request)
    {
        $id_array = $request->input('id');

        $sendmails = IPLIST::whereIn('id', $id_array)->get();

        foreach ($sendmails as $sendmail) {
            $sendmail->delete();
        }
        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Deleted IP addresses';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();
        return response()->json(['success' => 'The IP address has been successfully removed.']);
    }

    public function resetipblock($id)
    {

        $ipreset = IPLIST::find($id);
        $ipreset->types = 'Unlock';
        $ipreset->update();

        $geolocation = GeoIP::getLocation(request()->getClientIp());
        $agent = new Agent();
        $activity = new EmployeeActivity();
        $activity->user_id = Auth::user()->id;
        $activity->activity_type = 'Ip address has been reset';
        $activity->ip_address = $geolocation->ip;
        $activity->browser = $agent->browser();
        $activity->device = $agent->device();
        $activity->save();
        return response()->json(['success' => 'Updated Successfully', 'data'=>$ipreset]);
    }
}
