<?php

namespace App\Http\Middleware;

use App\Models\Setting;
use Closure;
use Illuminate\Http\Request;
use Auth;
use App\Models\User;
use Carbon\Carbon;
// use Spatie\Honeypot\ProtectAgainstSpam;

class AdminAuthenticate
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        $user = Auth::user();
        if ($user) {
            $timezone = explode(' ', $user->timezone);
            if ($timezone) {
                $secondPart = str_replace(['(', ')'], '', $timezone[0]);
                $user->update(['last_activity' => Carbon::now()]);
            }
        }
        $showAlertOnceAfter = now()->addMinutes(setting('admin_users_inactive_auto_logout_time'));
        $logoutOnceafter = now()->addMinutes((int) setting('admin_users_inactive_auto_logout_time') + 1);
        session()->put('last_activity', now());
        session()->put('showAlertOnceAfter', $showAlertOnceAfter);
        session()->put('logoutOnceafter', $logoutOnceafter);
        if (!$request->is('detail/admin/licenseinfoenter') && !$request->is('detail/admin/ticketuserlicenseverify')) {
            if (setting('Employe_email_two_fact') == 'on' &&  User::where(['id' => Auth::id(), 'twofactorauth' => 'emailtwofact'])->exists()) {
                if (Auth::check() && Auth::user()->status == '1' && session()->get('admintwofactoremail') == Auth::user()->email) {
                    return $next($request);
                } else {
                    if (Auth::check() && Auth::user()->status == '1') {
                        $userType = $request->route()->action['prefix'];
                        $exploded = explode('/', $userType)[1];
                        $response = response(['email' => Auth::user()->email]);
                        if ($exploded === 'admin') {
                            $response->header('email', Auth::user()->email);
                            $response->header('Twofactor', 'admin');
                        }
                        return $response;
                    } else {
                        Auth::logout();
                        $userType = $request->route()->action['prefix'];
                        $exploded = explode('/', $userType)[1];
                        $response = response()->json(['message' => 'User logged out successfully']);
                        if ($exploded === 'admin') {
                            $response->header('X-User-Type', 'admin');
                        }
                        return $response;
                    }
                }
            } elseif (setting('Employe_google_two_fact') == 'on' && User::where(['id' => Auth::id(), 'twofactorauth' => 'googletwofact'])->exists()) {

                if (Auth::check() && Auth::user()->status == '1'  && session()->get('admingoogleauthid') == Auth::user()->email) {
                    return $next($request);
                } else {
                    if (Auth::check() && Auth::user()->status == '1') {
                        $userType = $request->route()->action['prefix'];
                        $exploded = explode('/', $userType)[1];
                        $response = response(['email' => Auth::user()->email]);
                        if ($exploded === 'admin') {
                            $response->header('email', Auth::user()->email);
                            $response->header('Google2fa', 'admin');
                        }

                        return $response;
                    } else {
                        Auth::logout();
                        $userType = $request->route()->action['prefix'];
                        $exploded = explode('/', $userType)[1];
                        $response = response()->json(['message' => 'User logged out successfully']);
                        if ($exploded === 'admin') {
                            $response->header('X-User-Type', 'admin');
                        }
                        return $response;
                    }
                }
            } else {
                if (Auth::check() && Auth::user()->status == '1') {
                    return $next($request);
                } else {

                    Auth::logout();
                    $userType = $request->route()->action['prefix'];
                    $exploded = explode('/', $userType)[1];
                    $response = response()->json(['message' => 'User logged out successfully']);
                    if ($exploded === 'admin') {
                        $response->header('X-User-Type', 'admin');
                    }
                    return $response;
                }
            }
        } else {
            return $next($request);
        }
    }
}
