<?php

namespace App\Http\Middleware;

use Illuminate\Support\Facades\Route;
use Closure;
use Illuminate\Http\Request;
use DB;

class HttpsProtocolMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        try {
            DB::connection()->getPdo();
            if (!DB::getSchemaBuilder()->hasTable('settings')) {

                return $next($request);
            } else {

                if ($request->isMethod('get')) {
                    // Execute the request and get the response
                    $path = $request->path();
                    
        $hasInstall = strpos($path, '/install'); // Check if '/install' is present in the path
        $hasNewUpdate = strpos($path, 'newupdate'); // Check if 'newupdate' parameter exists in the request

if($hasInstall != 0  && $hasNewUpdate != 0){
                    // Check if the path exists in the registered routes
                    $routes = Route::getRoutes();
                    foreach ($routes as $route) {

                            // Get the route's URI
                            $routeUri = $route->uri();

                            // Check if the accessed path matches the route's URI
                            if ($path === $routeUri) {
                                // return $next($request);
                                $response = $next($request);

                                // Check if the request is a GET request
                                // Get the content of the response
                                $content = $response->content();

                                // Decode the JSON content into an associative array
                                $data = json_decode($content, true);

                                if (setting('admin_users_inactive_auto_logout')) {
                                    $data['admin_users_inactive_auto_logout'] = setting('admin_users_inactive_auto_logout');
                                    $data['admin_users_inactive_auto_logout_time'] = setting('admin_users_inactive_auto_logout_time');
                                }
                                if (setting('customer_inactive_auto_logout')) {
                                    $data['customer_inactive_auto_logout'] = setting('customer_inactive_auto_logout');
                                    $data['customer_inactive_auto_logout_time'] = setting('customer_inactive_auto_logout_time');
                                }
                                // Add custom properties to the data

                                // Encode the modified data back to JSON
                                // $content = json_encode($data);

                                $plaintext = json_encode($data);
                                $encrypted = base64_encode($plaintext);
                                $encrypte = json_encode(['encrypted' => $encrypted]);
                                // Set the modified content to the response
                                $response->setContent($encrypte);

                                if (setting('FORCE_SSL') == 'on') {
                                    if (!$request->secure()) {
                                        return redirect()->secure($request->getPathInfo());
                                    }
                                    return $response;
                                } else {
                                    return $response;
                                }
                            }
                        }
}
                }

                // Return the response

                if (setting('FORCE_SSL') == 'on') {
                    if (!$request->secure()) {
                        return redirect()->secure($request->getPathInfo());
                    }
                    return $next($request);
                } else {
                    return $next($request);
                }
            }
        } catch (\Exception $e) {
            return $next($request);
            die("Could not connect to the database.  Please check your configuration. error:" . $e);
        }
    }
}
