<?php

namespace App\Models\Articles;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;

use App\Models\Ticket\Category;
use App\Models\Role;
use App\Models\ArticleComment;
use App\Models\Articles\article_likes;
use App\Models\Articles\Category_articles;
use App\Models\Subcategory;


class Article extends Model implements HasMedia
{
    use HasFactory;
    use InteractsWithMedia;



    protected $fillable = [
        'category_id', 'title', 'message', 'status', 'featureimage','views','tags',
    ];

    public function category()
    {
        return $this->belongsTo(Category::class, 'category_id');
    }

    public function cat()
    {
        return $this->belongsTo(Category_articles::class);
    }
    public function role()
    {
        return $this->belongsTo(Role::class);
    }

    public function articlecomments()
    {
        return $this->hasMany(ArticleComment::class);
    }

    public function article_likes()
    {
        return $this->hasMany(article_likes::class);
    }
    
    public function article_like()
    {
        return $this->hasMany(article_likes::class, 'rating');
    }
   
    public function registerMediaCollections(): void
    {
        $this->addMediaCollection('article');
            //add option
    }

    public function subcategorys()
    {
        return $this->belongsTo(Subcategory::class, 'subcategory', 'id');
    }

    
    protected static function booted()
    {
        // Use retrieved event to automatically set the "image" attribute when loading an existing model

        static::updating(function ($model) {
            if ($model['profileimage']) {
                unset($model['profileimage']);
            }
            if ($model['articlefeatureimage']) {
                unset($model['articlefeatureimage']);
            }
            return;
        });
        static::retrieved(function ($model) {
            $model->setImageValAttribute();
        });
    }

    // Define a method to set the "image" attribute
    protected function setImageValAttribute()
    {
        if ($this->featureimage) {
            $storage_disk = $this->storage_disk ?? 'public';
            $provider = existprovider($storage_disk)->provider;
            // $imageUrl = $provider::getImageUrl($this->image);
            $imageUrl = $provider::getImageUrl('uploads/featureimage' . '/' . $this->featureimage);
            // Only set the "image" attribute if it's not already set
            if ($this['articlefeatureimage'] !== $imageUrl) {
                $this['articlefeatureimage'] = $imageUrl;
            }
        }
    }
    
}
