<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RefundComment extends Model
{
    use HasFactory;
    
    protected $fillable = [
        'cust_id',
        'refund_id',
        'user_id',
        'comment',
    ];

    public function user()
    {
        return $this->belongsTo(User::class,'user_id');
    }

    public function cust()
    {
        return $this->belongsTo(Customer::class,'cust_id');
    }
}
