<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class callaction extends Model
{
    use HasFactory;

    protected $fillable = [
        
        'callcheck',
        'title',
        'subtitle',
        'storage_disk',
        'buttonname',
        'buttonurl',
        'image',
    ];
    
    protected static function booted()
    {
        // Use retrieved event to automatically set the "image" attribute when loading an existing model

        static::updating(function ($model) {
            if ($model['profileimage']) {
                unset($model['profileimage']);
            }
            return;
        });
        static::retrieved(function ($model) {
            $model->setImageValAttribute();
        });
    }

    // Define a method to set the "image" attribute
    protected function setImageValAttribute()
    {
        if ($this->image) {
            $storage_disk = $this->storage_disk ?? 'public';
            $provider = existprovider($storage_disk)->provider;
            // $imageUrl = $provider::getImageUrl($this->image);
            $imageUrl = $provider::getImageUrl('uploads/callaction' . '/' . $this->image);
            // Only set the "image" attribute if it's not already set
            if ($this['profileimage'] !== $imageUrl) {
                $this['profileimage'] = $imageUrl;
            }
        }else{
            $this['profileimage'] = asset('./uploads/callaction/noimage/noimage.png');
        }
    }
}
