<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

use App\Models\Ticket\Ticket;

class TicketCreateNotifications extends Notification
{
    use Queueable;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct(Ticket $ticket)
    {
        $this->ticket = $ticket;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['database'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        return (new MailMessage)
                    ->line('The introduction to the notification.')
                    ->action('Notification Action', url('/'))
                    ->line('Thank you for using our application!');
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            'ticket_id' => $this->ticket->ticket_id,
            'title' => $this->ticket->subject,
            'category' => $this->ticket->category_id ? $this->ticket->category != null ? $this->ticket->category->name : null : null,
            'status' => $this->ticket->status,
            'replystatus' => $this->ticket->replystatus,
            'overduestatus' => $this->ticket->overduestatus,
            'link' => url('/admin/ticket-view/'.encrypt($this->ticket->ticket_id)),
            'clink' => url('/customer/ticket-view/'.encrypt($this->ticket->ticket_id)),
        ];
    }
}
