<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('custom_invoice_fields', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('parentId');
            $table->string('title');
            $table->text('description');
            $table->integer('price');
            $table->integer('quantity')->nullable();
            $table->integer('amount')->nullable();
            $table->string('customerPrice')->nullable();
            $table->foreign('parentId')->references('id')->on('all_transactions')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('custom_invoice_fields');
    }
};
