<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        //
        Schema::table('social_auth_settings', function (Blueprint $table) {

            $table->dropColumn('facebook_client_id');
            $table->dropColumn('facebook_secret_id');
            $table->dropColumn('facebook_status');

            $table->dropColumn('twitter_client_id');
            $table->dropColumn('twitter_secret_id');
            $table->dropColumn('twitter_status');

            $table->string('microsoft_app_id')->nullable();
            $table->string('microsoft_secret_id')->nullable();
            $table->enum('microsoft_status', ['enable', 'disable'])->default('disable');
        });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        //
        Schema::table('social_auth_settings', function (Blueprint $table) {
            $table->string('facebook_client_id')->nullable();
            $table->string('facebook_secret_id')->nullable();
            $table->enum('facebook_status', ['enable', 'disable'])->default('disable');
            $table->string('twitter_client_id')->nullable();
            $table->string('twitter_secret_id')->nullable();
            $table->enum('twitter_status', ['enable', 'disable'])->default('disable');
        });
    }
};
