<?php

namespace Database\Seeders;

use App\Models\EmailTemplate;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class EmailFieldsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $emailtemplate = EmailTemplate::where('code','customer_sendmail_contactus')->first();
        $emailtemplate->variables_used = 'Contact_name,Contact_email,Contact_subject,Contact_phone,Contact_message';
        $emailtemplate->save();
        $emailtemplate = EmailTemplate::where('code','admin_sendmail_contactus')->first();
        $emailtemplate->variables_used = 'Contact_name,Contact_email,Contact_subject,Contact_phone,Contact_message';
        $emailtemplate->save();
        $emailtemplate = EmailTemplate::where('code','customer_sendmail_verification')->first();
        $emailtemplate->variables_used = 'username, email, email_verify_url';
        $emailtemplate->save();
        $emailtemplate = EmailTemplate::where('code','customer_send_ticket_created')->first();
        $emailtemplate->variables_used = 'ticket_username,ticket_id, ticket_title,ticket_status,ticket_description,ticket_customer_url,ticket_admin_url';
        $emailtemplate->save();
        $emailtemplate = EmailTemplate::where('code','admin_send_email_ticket_created')->first();
        $emailtemplate->variables_used = 'ticket_username,ticket_id, ticket_title,ticket_status,ticket_description,ticket_customer_url,ticket_admin_url';
        $emailtemplate->save();
        $emailtemplate = EmailTemplate::where('code','customer_send_ticket_reply')->first();
        $emailtemplate->variables_used = 'ticket_username,ticket_title,ticket_id,ticket_status,comment,ticket_admin_url,ticket_customer_url';
        $emailtemplate->save();
        $emailtemplate = EmailTemplate::where('code','customer_rating')->first();
        $emailtemplate->variables_used = 'closed_agent_name,closed_agent_role,ticket_username,ticket_title,ticket_id,comment,ticket_status,ratinglink,ticket_customer_url,ticket_admin_url';
        $emailtemplate->save();
        $emailtemplate = EmailTemplate::where('code','customer_send_ticket_reopen')->first();
        $emailtemplate->variables_used = 'ticket_username,ticket_id,ticket_title,ticket_description,ticket_status,ticket_customer_url,ticket_admin_url';
        $emailtemplate->save();
        $emailtemplate = EmailTemplate::where('code','forget_password')->first();
        $emailtemplate->variables_used = 'reset_password_url';
        $emailtemplate->save();
        $emailtemplate = EmailTemplate::where('code','customer_send_registration_details')->first();
        $emailtemplate->variables_used = 'userpassword,username,useremail,url';
        $emailtemplate->save();
        $emailtemplate = EmailTemplate::where('code','employee_send_registration_details')->first();
        $emailtemplate->variables_used = 'userpassword,username,useremail,url';
        $emailtemplate->save();
        $emailtemplate = EmailTemplate::where('code','customer_send_guestticket_created')->first();
        $emailtemplate->variables_used = 'ticket_username,ticket_id,ticket_title,ticket_status,ticket_description,ticket_customer_url,ticket_admin_url';
        $emailtemplate->save();
        $emailtemplate = EmailTemplate::where('code','customer_send_ticket_overdue')->first();
        $emailtemplate->variables_used = 'ticket_username,ticket_title,ticket_overduetime,ticket_id,ticket_description,ticket_status,ticket_customer_url,ticket_admin_url';
        $emailtemplate->save();
        $emailtemplate = EmailTemplate::where('code','customer_send_ticket_response')->first();
        $emailtemplate->variables_used = 'ticket_username,ticket_closingtime,ticket_title,ticket_id,ticket_description,ticket_status,replystatus,ticket_customer_url,ticket_admin_url';
        $emailtemplate->save();
        $emailtemplate = EmailTemplate::where('code','customer_send_ticket_autoclose')->first();
        $emailtemplate->variables_used = 'ticket_username,ticket_id,ticket_title,ticket_description,ticket_status,ticket_customer_url,ticket_admin_url';
        $emailtemplate->save();
        $emailtemplate = EmailTemplate::where('code','Send_email_to_customer_when_Ticket_is_Overdue')->first();
        $emailtemplate->variables_used = 'ticket_username,ticket_title,ticket_overduetime,ticket_id,ticket_description,ticket_status,ticket_customer_url,ticket_admin_url';
        $emailtemplate->save();
        $emailtemplate = EmailTemplate::where('code','Send_email_to_customer_when_change_email')->first();
        $emailtemplate->body = '<div>Hello {{username}},</div><div><br></div><div>We have received a request to change the email address associated with your account from {{useremail}} to a new email address.</div><div><br></div><div>To complete the process, please click on the link below:</div><div><br></div><div><a href="{{ticket_customer_url}}" target="_blank">{{ticket_customer_url}}</a></div><div><br></div><div>If you did not initiate this request or if you have any concerns, please contact our support team for assistance.</div><div><br></div><div>Thank you,</div><div>Support Team</div>';
        $emailtemplate->variables_used = 'username,useremail,ticket_customer_url';
        $emailtemplate->save();
        $emailtemplate = EmailTemplate::where('code','Send_email_to_admin_users_when_change_email')->first();
        $emailtemplate->body = '<div>Hello {{username}},</div><div><br></div><div>We have received a request to change the email address associated with your account from {{useremail}} to a new email address.</div><div><br></div><div>To complete the process, please click on the link below:</div><div><br></div><div><a href="{{ticket_admin_url}}" target="_blank">{{ticket_admin_url}}</a></div><div><br></div><div>If you did not initiate this request or if you have any concerns, please contact our support team for assistance.</div><div><br></div><div>Thank you,</div><div>Support Team</div>';
        $emailtemplate->variables_used = 'username,useremail,ticket_admin_url';
        $emailtemplate->save();
        $emailtemplate = EmailTemplate::where('code','Send_email_to_customer_when_change_email_otp_verification')->first();
        $emailtemplate->variables_used = 'otp,useremail,username';
        $emailtemplate->save();
        $emailtemplate = EmailTemplate::where('code','Send_email_to_admin_when_ticket_draft_created')->first();
        $emailtemplate->variables_used = 'username,ticket_id,ticket_description,created_or_respond,ticket_admin_url';
        $emailtemplate->save();
        $emailtemplate = EmailTemplate::where('code','Send_email_to_customer_when_voilation_is_ticket_or_customer')->first();
        $emailtemplate->variables_used = 'ticket_username,username,ticket_id,ticket_title,ticket_status,ticket_description,ticket_customer_url,ticket_admin_url';
        $emailtemplate->save();
        $emailtemplate = EmailTemplate::where('code','customer_send_ticket_created_that_holiday_or_announcement')->first();
        $emailtemplate->variables_used = 'ticket_username,ticket_title,ticket_id,ticket_status,comment,ticket_admin_url,ticket_customer_url';
        $emailtemplate->save();
        $emailtemplate = EmailTemplate::where('code','two_factor_authentication_otp_send')->first();
        $emailtemplate->variables_used = 'otp,email,name';
        $emailtemplate->save();
        $emailtemplate = EmailTemplate::where('code','send_a_reply_to_the_customer_when_a_customer_responds_to_a_closed_email_ticket')->first();
        $emailtemplate->variables_used = 'ticket_id,ticket_username,ticket_title,ticket_description,ticket_customer_url,ticket_admin_url,url';
        $emailtemplate->save();
        $emailtemplate = EmailTemplate::where('code','admin_send_email_ticket_reply')->first();
        $emailtemplate->variables_used = 'ticket_username,ticket_title,ticket_id,ticket_status,comment,ticket_admin_url,ticket_customer_url';
        $emailtemplate->save();
        $emailtemplate = EmailTemplate::where('code','when_ticket_assign_to_other_employee')->first();
        $emailtemplate->variables_used = 'ticket_username,ticket_id,ticket_title,ticket_description,ticket_admin_url';
        $emailtemplate->save();
        $emailtemplate = EmailTemplate::where('code','when_send_customnotify_email_to_selected_member')->first();
        $emailtemplate->variables_used = 'notification_subject,notification_message,notification_tag';
        $emailtemplate->save();
        $emailtemplate = EmailTemplate::where('code','when_send_customnotify_email_todelete_member')->first();
        $emailtemplate->variables_used = 'customer_username,customer_email,customer_time,customer_months,ticket_customer_url';
        $emailtemplate->save();
        $emailtemplate = EmailTemplate::where('code','admin_sendemail_whenticketclosed')->first();
        $emailtemplate->variables_used = 'ticket_username,ticket_id,ticket_title,ticket_description,ticket_status,comment,ticket_customer_url,ticket_admin_url';
        $emailtemplate->save();
        $emailtemplate = EmailTemplate::where('code','customer_sendemail_whenticketclosed')->first();
        $emailtemplate->variables_used = 'ticket_username,ticket_id,ticket_title,ticket_description,ticket_status,comment,ticket_customer_url,ticket_admin_url';
        $emailtemplate->save();
        $emailtemplate = EmailTemplate::where('code','CCmail_sendemail_whenticketclosed')->first();
        $emailtemplate->variables_used = 'ticket_username,ticket_id,ticket_title,ticket_status,comment,ticket_description,ticket_customer_url,ticket_admin_url';
        $emailtemplate->save();
        $emailtemplate = EmailTemplate::where('code','admin_sendemail_whenticketreopen')->first();
        $emailtemplate->variables_used = 'ticket_username,ticket_id,ticket_title,ticket_description,ticket_status,ticket_customer_url,ticket_admin_url';
        $emailtemplate->save();
        $emailtemplate = EmailTemplate::where('code','send_mail_to_customer_when_ticket_closed_by_admin')->first();
        $emailtemplate->variables_used = 'closed_agent_name,closed_agent_role,ticket_username,ticket_title,ticket_id,comment,ticket_status,ratinglink,ticket_customer_url,ticket_admin_url';
        $emailtemplate->save();
        $emailtemplate = EmailTemplate::where('code','send_mail_to_agent_when_ticket_closed_by_admin_or_agent')->first();
        $emailtemplate->variables_used = 'closed_agent_name,closed_agent_role,ticket_username,ticket_title,ticket_id,comment,ticket_status,ticket_customer_url,ticket_admin_url';
        $emailtemplate->save();
        $emailtemplate = EmailTemplate::where('code','send_mail_admin_panel_users_when_category_changed')->first();
        $emailtemplate->variables_used = 'ticket_id,ticket_title,ticket_description,ticket_status,ticket_oldcategory,ticket_changedcategory,ticket_customer_url,ticket_admin_url';
        $emailtemplate->save();
        $emailtemplate = EmailTemplate::where('code','send_mail_customer_when_category_changed')->first();
        $emailtemplate->variables_used = 'ticket_username,ticket_id,ticket_title,ticket_description,ticket_status,ticket_oldcategory,ticket_changedcategory,ticket_customer_url,ticket_admin_url';
        $emailtemplate->save();
        $emailtemplate = EmailTemplate::where('code','send_mail_to_admin_when_ticket_note_created')->first();
        $emailtemplate->variables_used = 'ticket_id,note_username,ticket_note,ticket_admin_url';
        $emailtemplate->save();
        $emailtemplate = EmailTemplate::where('code','customer_send_guestticket_created_with_attachment_failed')->first();
        $emailtemplate->variables_used = 'ticket_id,ticket_username,ticket_title,ticket_file_format,ticket_file_size,ticket_file_count,ticket_description,ticket_customer_url,ticket_admin_url';
        $emailtemplate->save();
        $emailtemplate = EmailTemplate::where('code','guestticket_email_verification')->first();
        $emailtemplate->variables_used = 'guestemail,guestotp,guestname';
        $emailtemplate->save();
        $emailtemplate = EmailTemplate::where('code','guestticket_email_verification_view')->first();
        $emailtemplate->variables_used = 'guestemail,guestotp,guestname';
        $emailtemplate->save();
        $emailtemplate = EmailTemplate::where('code','send_mail_customer_when_a_customer_responds_to_a_restricted_mails')->first();
        $emailtemplate->variables_used = '';
        $emailtemplate->save();
    }
}
