<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Database\Eloquent\Model;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class PermissionTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Model::unguard();

        // create permissions
        $this->createPermissions();

        // assign roles and permissions
        $this->assignPermissions();
        // $this->call("OthersTableSeeder");
    }

    public function createPermissions()
    {
        $per = [
            //Edit Profile
            ['id' => 1, 'name' => 'Profile Edit', 'guard_name' => 'web', 'permissionsgroupname' => 'Profile Edit'],
            //Ticket Permission
            ['id' => 2, 'name' => 'Ticket Create', 'guard_name' => 'web', 'permissionsgroupname' => 'Tickets'],
            ['id' => 3, 'name' => 'Ticket Edit', 'guard_name' => 'web', 'permissionsgroupname' => 'Tickets'],
            ['id' => 4, 'name' => 'Ticket Delete', 'guard_name' => 'web', 'permissionsgroupname' => 'Tickets'],
            ['id' => 5, 'name' => 'Ticket Assign', 'guard_name' => 'web', 'permissionsgroupname' => 'Tickets'],
            // Category Permission
            ['id' => 6, 'name' => 'Category Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Category'],
            ['id' => 7, 'name' => 'Category Create', 'guard_name' => 'web', 'permissionsgroupname' => 'Category'],
            ['id' => 8, 'name' => 'Category Edit', 'guard_name' => 'web', 'permissionsgroupname' => 'Category'],
            ['id' => 9, 'name' => 'Category Delete', 'guard_name' => 'web', 'permissionsgroupname' => 'Category'],
            ['id' => 10, 'name' => 'Category Assign To Groups', 'guard_name' => 'web', 'permissionsgroupname' => 'Category'],
            ['id' => 11, 'name' => 'Categories Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Category'],
            ['id' => 12, 'name' => 'Subcategory Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Category'],
            ['id' => 13, 'name' => 'Subcategory Create', 'guard_name' => 'web', 'permissionsgroupname' => 'Category'],
            ['id' => 14, 'name' => 'Subcategory Edit', 'guard_name' => 'web', 'permissionsgroupname' => 'Category'],
            ['id' => 15, 'name' => 'Subcategory Delete', 'guard_name' => 'web', 'permissionsgroupname' => 'Category'],
            //Knowoldge permision
            ['id' => 16, 'name' => 'Knowledge Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Knowledge'],
            //Article permision
            ['id' => 17, 'name' => 'Article Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Knowledge'],
            ['id' => 18, 'name' => 'Article Create', 'guard_name' => 'web', 'permissionsgroupname' => 'Knowledge'],
            ['id' => 19, 'name' => 'Article View', 'guard_name' => 'web', 'permissionsgroupname' => 'Knowledge'],
            ['id' => 20, 'name' => 'Article Edit', 'guard_name' => 'web', 'permissionsgroupname' => 'Knowledge'],
            ['id' => 21, 'name' => 'Article Delete', 'guard_name' => 'web', 'permissionsgroupname' => 'Knowledge'],
            //project premission
            ['id' => 22, 'name' => 'Project Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Project'],
            ['id' => 23, 'name' => 'Project Create', 'guard_name' => 'web', 'permissionsgroupname' => 'Project'],
            ['id' => 24, 'name' => 'Project Edit', 'guard_name' => 'web', 'permissionsgroupname' => 'Project'],
            ['id' => 25, 'name' => 'Project Delete', 'guard_name' => 'web', 'permissionsgroupname' => 'Project'],
            ['id' => 26, 'name' => 'Project Assign', 'guard_name' => 'web', 'permissionsgroupname' => 'Project'],
            ['id' => 27, 'name' => 'Project Importlist', 'guard_name' => 'web', 'permissionsgroupname' => 'Project'],
            //Department Permission
            ['id' => 28, 'name' => 'Department Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Department'],
            ['id' => 29, 'name' => 'Department Create', 'guard_name' => 'web', 'permissionsgroupname' => 'Department'],
            ['id' => 30, 'name' => 'Department Edit', 'guard_name' => 'web', 'permissionsgroupname' => 'Department'],
            ['id' => 31, 'name' => 'Department Delete', 'guard_name' => 'web', 'permissionsgroupname' => 'Department'],
            //Manage Roles
            ['id' => 32, 'name' => 'Managerole Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Roles & Permission'],
            //Roles & Permission
            ['id' => 33, 'name' => 'Roles & Permission Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Roles & Permission'],
            ['id' => 34, 'name' => 'Roles & Permission Create', 'guard_name' => 'web', 'permissionsgroupname' => 'Roles & Permission'],
            ['id' => 35, 'name' => 'Roles & Permission Edit', 'guard_name' => 'web', 'permissionsgroupname' => 'Roles & Permission'],
            //Landing Page permision
            ['id' => 36, 'name' => 'Landing Page Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Landing Page Setting'],
            //Banner Access
            ['id' => 37, 'name' => 'Banner Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Landing Page Setting'],
            //Call To Action
            ['id' => 38, 'name' => 'Call To Action Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Landing Page Setting'],
            //Customers Permission
            ['id' => 39, 'name' => 'Customers Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Customer'],
            ['id' => 40, 'name' => 'Customers Create', 'guard_name' => 'web', 'permissionsgroupname' => 'Customer'],
            ['id' => 41, 'name' => 'Customers Edit', 'guard_name' => 'web', 'permissionsgroupname' => 'Customer'],
            ['id' => 42, 'name' => 'Customers Delete', 'guard_name' => 'web', 'permissionsgroupname' => 'Customer'],
            ['id' => 43, 'name' => 'Customers Importlist', 'guard_name' => 'web', 'permissionsgroupname' => 'Customer'],
            ['id' => 44, 'name' => 'Customers Login', 'guard_name' => 'web', 'permissionsgroupname' => 'Customer'],
            //  Canned Response
            ['id' => 45, 'name' => 'Canned Response Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Canned Response'],
            ['id' => 46, 'name' => 'Canned Response Create', 'guard_name' => 'web', 'permissionsgroupname' => 'Canned Response'],
            ['id' => 47, 'name' => 'Canned Response Edit', 'guard_name' => 'web', 'permissionsgroupname' => 'Canned Response'],
            ['id' => 48, 'name' => 'Canned Response Delete', 'guard_name' => 'web', 'permissionsgroupname' => 'Canned Response'],
            // Envato
            ['id' => 49, 'name' => 'Envato Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Envato'],
            ['id' => 50, 'name' => 'Envato API Token Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Envato'],
            ['id' => 51, 'name' => 'Envato License Details Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Envato'],
            // App Info
            ['id' => 52, 'name' => 'App Info Access', 'guard_name' => 'web', 'permissionsgroupname' => 'App Info'],
            ['id' => 53, 'name' => 'App Purchase Code Access', 'guard_name' => 'web', 'permissionsgroupname' => 'App Info'],
            //Employee permision
            ['id' => 54, 'name' => 'Employee Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Employee'],
            ['id' => 55, 'name' => 'Employee Create', 'guard_name' => 'web', 'permissionsgroupname' => 'Employee'],
            ['id' => 56, 'name' => 'Employee Edit', 'guard_name' => 'web', 'permissionsgroupname' => 'Employee'],
            ['id' => 57, 'name' => 'Employee Delete', 'guard_name' => 'web', 'permissionsgroupname' => 'Employee'],
            ['id' => 58, 'name' => 'Employee Importlist', 'guard_name' => 'web', 'permissionsgroupname' => 'Employee'],
            ['id' => 59, 'name' => 'Reset Password', 'guard_name' => 'web', 'permissionsgroupname' => 'Employee'],
            ['id' => 60, 'name' => 'Employee Status', 'guard_name' => 'web', 'permissionsgroupname' => 'Employee'],
            //Feature Box
            ['id' => 61, 'name' => 'Feature Box Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Feature Box'],
            ['id' => 62, 'name' => 'Feature Box Create', 'guard_name' => 'web', 'permissionsgroupname' => 'Feature Box'],
            ['id' => 63, 'name' => 'Feature Box Edit', 'guard_name' => 'web', 'permissionsgroupname' => 'Feature Box'],
            ['id' => 64, 'name' => 'Feature Box Delete', 'guard_name' => 'web', 'permissionsgroupname' => 'Feature Box'],
            //Testimonial Permission
            ['id' => 65, 'name' => 'Testimonial Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Testimonial'],
            ['id' => 66, 'name' => 'Testimonial Create', 'guard_name' => 'web', 'permissionsgroupname' => 'Testimonial'],
            ['id' => 67, 'name' => 'Testimonial Edit', 'guard_name' => 'web', 'permissionsgroupname' => 'Testimonial'],
            ['id' => 68, 'name' => 'Testimonial Delete', 'guard_name' => 'web', 'permissionsgroupname' => 'Testimonial'],
            //FAQs Permission
            ['id' => 69, 'name' => 'FAQs Access', 'guard_name' => 'web', 'permissionsgroupname' => 'FAQ`s'],
            ['id' => 70, 'name' => 'FAQs Create', 'guard_name' => 'web', 'permissionsgroupname' => 'FAQ`s'],
            ['id' => 71, 'name' => 'FAQs Edit', 'guard_name' => 'web', 'permissionsgroupname' => 'FAQ`s'],
            ['id' => 72, 'name' => 'FAQs Delete', 'guard_name' => 'web', 'permissionsgroupname' => 'FAQ`s'],
            ['id' => 73, 'name' => 'Main FAQ Access', 'guard_name' => 'web', 'permissionsgroupname' => 'FAQ`s'],
            ['id' => 74, 'name' => 'FAQ Category Access', 'guard_name' => 'web', 'permissionsgroupname' => 'FAQ`s'],
            ['id' => 75, 'name' => 'FAQ Category Create', 'guard_name' => 'web', 'permissionsgroupname' => 'FAQ`s'],
            ['id' => 76, 'name' => 'FAQ Category Edit', 'guard_name' => 'web', 'permissionsgroupname' => 'FAQ`s'],
            ['id' => 77, 'name' => 'FAQ Category Delete', 'guard_name' => 'web', 'permissionsgroupname' => 'FAQ`s'],
            //Groups Permission
            ['id' => 78, 'name' => 'Groups Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Groups'],
            ['id' => 79, 'name' => 'Groups List Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Groups'],
            ['id' => 80, 'name' => 'Groups Create', 'guard_name' => 'web', 'permissionsgroupname' => 'Groups'],
            ['id' => 81, 'name' => 'Groups Edit', 'guard_name' => 'web', 'permissionsgroupname' => 'Groups'],
            ['id' => 82, 'name' => 'Groups Delete', 'guard_name' => 'web', 'permissionsgroupname' => 'Groups'],
            //Custom Notifications
            ['id' => 83, 'name' => 'Custom Notifications Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Custom Notifications'],
            ['id' => 84, 'name' => 'Custom Notifications View', 'guard_name' => 'web', 'permissionsgroupname' => 'Custom Notifications'],
            ['id' => 85, 'name' => 'Custom Notifications Delete', 'guard_name' => 'web', 'permissionsgroupname' => 'Custom Notifications'],
            ['id' => 86, 'name' => 'Custom Notifications Employee', 'guard_name' => 'web', 'permissionsgroupname' => 'Custom Notifications'],
            ['id' => 87, 'name' => 'Custom Notifications Customer', 'guard_name' => 'web', 'permissionsgroupname' => 'Custom Notifications'],
            //Custom Pages
            ['id' => 88, 'name' => 'Custom Pages Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Custom pages'],
            //Pages
            ['id' => 89, 'name' => 'Pages Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Custom pages'],
            ['id' => 90, 'name' => 'Pages Create', 'guard_name' => 'web', 'permissionsgroupname' => 'Custom pages'],
            ['id' => 91, 'name' => 'Pages View', 'guard_name' => 'web', 'permissionsgroupname' => 'Custom pages'],
            ['id' => 92, 'name' => 'Pages Edit', 'guard_name' => 'web', 'permissionsgroupname' => 'Custom pages'],
            ['id' => 93, 'name' => 'Pages Delete', 'guard_name' => 'web', 'permissionsgroupname' => 'Custom pages'],
            // 404 page
            ['id' => 94, 'name' => '404 Error Page Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Custom pages'],
            // Under Maintanance page
            ['id' => 95, 'name' => 'Under Maintenance Page Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Custom pages'],
            // Business Hours
            ['id' => 96, 'name' => 'Business Hours Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Business Hours'],
            // Custom fields
            ['id' => 97, 'name' => 'CustomField Access', 'guard_name' => 'web', 'permissionsgroupname' => 'CustomField'],
            ['id' => 98, 'name' => 'CustomField Create', 'guard_name' => 'web', 'permissionsgroupname' => 'CustomField'],
            ['id' => 99, 'name' => 'CustomField Edit', 'guard_name' => 'web', 'permissionsgroupname' => 'CustomField'],
            ['id' => 100, 'name' => 'CustomField Delete', 'guard_name' => 'web', 'permissionsgroupname' => 'CustomField'],
            // Languages
            ['id' => 101, 'name' => 'Languages Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Languages'],
            ['id' => 102, 'name' => 'Languages Create', 'guard_name' => 'web', 'permissionsgroupname' => 'Languages'],
            ['id' => 103, 'name' => 'Languages Edit', 'guard_name' => 'web', 'permissionsgroupname' => 'Languages'],
            ['id' => 104, 'name' => 'Languages Delete', 'guard_name' => 'web', 'permissionsgroupname' => 'Languages'],
            ['id' => 105, 'name' => 'Languages Translate', 'guard_name' => 'web', 'permissionsgroupname' => 'Languages'],
            // App Setting
            ['id' => 106, 'name' => 'App Setting Access', 'guard_name' => 'web', 'permissionsgroupname' => 'App Setting'],
            ['id' => 107, 'name' => 'General Setting Access', 'guard_name' => 'web', 'permissionsgroupname' => 'App Setting'],
            ['id' => 108, 'name' => 'Ticket Setting Access', 'guard_name' => 'web', 'permissionsgroupname' => 'App Setting'],
            ['id' => 109, 'name' => 'SEO Access', 'guard_name' => 'web', 'permissionsgroupname' => 'App Setting'],
            ['id' => 110, 'name' => 'Google Analytics Access', 'guard_name' => 'web', 'permissionsgroupname' => 'App Setting'],
            ['id' => 111, 'name' => 'Custom JS & CSS Access', 'guard_name' => 'web', 'permissionsgroupname' => 'App Setting'],
            ['id' => 112, 'name' => 'Captcha Setting Access', 'guard_name' => 'web', 'permissionsgroupname' => 'App Setting'],
            ['id' => 113, 'name' => 'Social Logins Access', 'guard_name' => 'web', 'permissionsgroupname' => 'App Setting'],
            ['id' => 114, 'name' => 'Email Setting Access', 'guard_name' => 'web', 'permissionsgroupname' => 'App Setting'],
            ['id' => 115, 'name' => 'Custom Chat Access', 'guard_name' => 'web', 'permissionsgroupname' => 'App Setting'],
            ['id' => 116, 'name' => 'Security Setting Access', 'guard_name' => 'web', 'permissionsgroupname' => 'App Setting'],
            // Emait to ticket
            ['id' => 117, 'name' => 'Emailtoticket Access', 'guard_name' => 'web', 'permissionsgroupname' => 'App Setting'],
            // IpList block
            ['id' => 118, 'name' => 'IpBlock Access', 'guard_name' => 'web', 'permissionsgroupname' => 'IP Block'],
            ['id' => 119, 'name' => 'IpBlock Add', 'guard_name' => 'web', 'permissionsgroupname' => 'IP Block'],
            ['id' => 120, 'name' => 'IpBlock Edit', 'guard_name' => 'web', 'permissionsgroupname' => 'IP Block'],
            ['id' => 121, 'name' => 'IpBlock Delete', 'guard_name' => 'web', 'permissionsgroupname' => 'IP Block'],
            //Announcements
            ['id' => 122, 'name' => 'Announcements Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Annoucements'],
            ['id' => 123, 'name' => 'Announcements Create', 'guard_name' => 'web', 'permissionsgroupname' => 'Annoucements'],
            ['id' => 124, 'name' => 'Announcements Edit', 'guard_name' => 'web', 'permissionsgroupname' => 'Annoucements'],
            ['id' => 125, 'name' => 'Announcements Delete', 'guard_name' => 'web', 'permissionsgroupname' => 'Annoucements'],
            //Email Template
            ['id' => 126, 'name' => 'Email Template Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Email Template'],
            ['id' => 127, 'name' => 'Email Template Edit', 'guard_name' => 'web', 'permissionsgroupname' => 'Email Template'],
            //Reports Template
            ['id' => 128, 'name' => 'Reports Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Reports'],
            // Holidays
            ['id' => 129, 'name' => 'Holidays Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Holidays'],
            ['id' => 130, 'name' => 'Holidays Create', 'guard_name' => 'web', 'permissionsgroupname' => 'Holidays'],
            ['id' => 131, 'name' => 'Holidays Edit', 'guard_name' => 'web', 'permissionsgroupname' => 'Holidays'],
            ['id' => 132, 'name' => 'Holidays Delete', 'guard_name' => 'web', 'permissionsgroupname' => 'Holidays'],
            ['id' => 133, 'name' => 'Holidays Import Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Holidays'],
            //Addons
            ['id' => 134, 'name' => 'Addon Access', 'guard_name' => 'web', 'permissionsgroupname' => 'Addons'],
            ['id' => 135, 'name' => 'Addon Add', 'guard_name' => 'web', 'permissionsgroupname' => 'Addons'],
            ['id' => 136, 'name' => 'Addon Edit', 'guard_name' => 'web', 'permissionsgroupname' => 'Addons'],
            //Profile Email Update
            ['id' => 137, 'name' => 'Email Update', 'guard_name' => 'web', 'permissionsgroupname' => 'Profile Edit'],
            
            ['id' => 138, 'name' => 'Bot Response Setting Access'  , 'guard_name' => 'web', 'permissionsgroupname' => 'App Setting'],
            ['id' => 139, 'name' => 'Twilio Setting Access'  , 'guard_name' => 'web', 'permissionsgroupname' => 'App Setting'],

            // Livechat perimissions
            ['id' => 140, 'name' => 'Livechat Access'  , 'guard_name' => 'web', 'permissionsgroupname' => 'Livechat'],
            ['id' => 141, 'name' => 'Customer Chat Process'  , 'guard_name' => 'web', 'permissionsgroupname' => 'Livechat'],
            ['id' => 142, 'name' => 'Operators'  , 'guard_name' => 'web', 'permissionsgroupname' => 'Livechat'],
            ['id' => 143, 'name' => 'Chat Flows'  , 'guard_name' => 'web', 'permissionsgroupname' => 'Livechat'],
            ['id' => 144, 'name' => 'Livechat Settings'  , 'guard_name' => 'web', 'permissionsgroupname' => 'Livechat'],
            ['id' => 145, 'name' => 'Livechat Ratings'  , 'guard_name' => 'web', 'permissionsgroupname' => 'Livechat'],
            ['id' => 146, 'name' => 'Domain Transfer Access'  , 'guard_name' => 'web', 'permissionsgroupname' => 'Domain Transfer'],

            ['id' => 147, 'name' => 'Currencies Access'  , 'guard_name' => 'web', 'permissionsgroupname' => 'Currencies'],
            ['id' => 148, 'name' => 'Payments Access'  , 'guard_name' => 'web', 'permissionsgroupname' => 'Payments'],
            ['id' => 149, 'name' => 'Currencies Add'  , 'guard_name' => 'web', 'permissionsgroupname' => 'Currencies'],
            ['id' => 150, 'name' => 'Currencies Edit'  , 'guard_name' => 'web', 'permissionsgroupname' => 'Currencies'],
            ['id' => 151, 'name' => 'Currencies Delete'  , 'guard_name' => 'web', 'permissionsgroupname' => 'Currencies'],

            ['id' => 152, 'name' => 'Refund Access'  , 'guard_name' => 'web', 'permissionsgroupname' => 'Payments'],
            ['id' => 153, 'name' => 'Custom Invoices Access'  , 'guard_name' => 'web', 'permissionsgroupname' => 'Payments'],
            ['id' => 154, 'name' => 'Payment Gateways Access'  , 'guard_name' => 'web', 'permissionsgroupname' => 'App Setting'],

            ['id' => 155, 'name' => 'Addspace Access'  , 'guard_name' => 'web', 'permissionsgroupname' => 'Addspace'],
            ['id' => 156, 'name' => 'Addspace Create'  , 'guard_name' => 'web', 'permissionsgroupname' => 'Addspace'],
            ['id' => 157, 'name' => 'Addspace Delete'  , 'guard_name' => 'web', 'permissionsgroupname' => 'Addspace'],
            ['id' => 158, 'name' => 'Addspace Edit'  , 'guard_name' => 'web', 'permissionsgroupname' => 'Addspace'],

            ['id' => 159, 'name' => 'AI Setup Access'  , 'guard_name' => 'web', 'permissionsgroupname' => 'AI Setup'],

            ['id' => 160, 'name' => 'Invoice Delete Access'  , 'guard_name' => 'web', 'permissionsgroupname' => 'Payments'],
            ['id' => 161, 'name' => 'Invoice Cancel Access'  , 'guard_name' => 'web', 'permissionsgroupname' => 'Payments'],
        ];

        foreach ($per as $pers) {
            Permission::updateOrCreate(['id' => $pers['id']], $pers);
        }
    }

    public function assignPermissions()
    {
        $role = Role::where('name', 'superadmin')->first();
        $permissions = Permission::get();
        foreach ($permissions as $code) {
            $role->givePermissionTo($code);
        };
    }
}
