<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use DB;

class SettingUpdateSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table('settings')->insert([
            [
                'key' => 'GUEST_TICKET_OTP',
                'value' => 'no',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'mail_key_set',
                'value' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'CUSTOMER_TICKET',
                'value' => 'no',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'start_week',
                'value' => '0',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'TICKET_CHARACTER',
                'value' => '10',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'default_timezone',
                'value' => 'UTC',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'businesshourstitle',
                'value' => 'Support',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'businesshourssubtitle',
                'value' => 'Our technical team is available in the IST timezone.',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'businesshoursswitch',
                'value' => 'on',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'supporticonimage',
                'value' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'admin_reply_mail',
                'value' => 'yes',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'customer_panel_employee_protect',
                'value' => 'off',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'employeeprotectname',
                'value' => 'Support',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'ticketrating',
                'value' => 'on',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'sidemenu_icon_style',
                'value' => 'off',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'login_disable',
                'value' => 'off',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'login_disable_statement',
                'value' => 'Due technical issue',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'cust_profile_delete_enable',
                'value' => 'off',
                'created_at' => now(),
                'updated_at' => now()
            ],

            [
                'key' => 'EMAILDOMAIN_BLOCKTYPE',
                'value' => 'blockemail',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'EMAILDOMAIN_LIST',
                'value' => '',
                'created_at' => now(),
                'updated_at' => now()
            ],

            [
                'key' => 'customer_inactive_notify',
                'value' => 'off',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'customer_inactive_notify_date',
                'value' => '1',
                'created_at' => now(),
                'updated_at' => now()
            ],

            [
                'key' => 'customer_inactive_week_date',
                'value' => '1',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'guest_inactive_notify',
                'value' => 'off',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'guest_inactive_notify_date',
                'value' => '1',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'guest_inactive_week_date',
                'value' => '1',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'RECAPTCH_ENABLE_ADMIN_LOGIN',
                'value' => 'NO',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'cc_email',
                'value' => 'h:mm a',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'contact_form_mail',
                'value' => env('contact_form_mail'),
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'only_social_logins',
                'value' => 'off',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'article_count',
                'value' => 'on',
                'created_at' => now(),
                'updated_at' => now()
            ],

            [
                'key' => 'trashed_ticket_autodelete',
                'value' => 'off',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'trashed_ticket_delete_time',
                'value' => '7',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'RESTRICT_TO_CREATE_TICKET',
                'value' => 'off',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'MAXIMUM_ALLOW_TICKETS',
                'value' => '1',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'MAXIMUM_ALLOW_HOURS',
                'value' => '1',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'SUPPORT_POLICY_URL',
                'value' => '#',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'RESTRICT_TO_REPLY_TICKET',
                'value' => 'off',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'MAXIMUM_ALLOW_REPLIES',
                'value' => 1,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'REPLY_ALLOW_IN_HOURS',
                'value' => 1,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'NOTE_CREATE_MAILS',
                'value' => 'off',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'ANNOUNCEMENT_USER',
                'value' => 'all_users',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'CUSTOMER_RESTICT_TO_DELETE_TICKET',
                'value' => 'off',
                'created_at' => now(),
                'updated_at' => now()
            ],

            [
                'key' => 'ENVATO_EXPIRED_BLOCK',
                'value' => 'off',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'MAX_FILE_UPLOAD',
                'value' => '2',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'terms_url',
                'value' => '#',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'purchasecode_on',
                'value' => 'off',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'defaultlogin_on',
                'value' => 'off',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'time_format',
                'value' => 'h:mm a',
                'created_at' => now(),
                'updated_at' => now()
            ],

        ]);
        DB::table('businesshours')->insert([
            [
                'no_id' => '1',
                'weeks' => null,
                'status' => null,
                'starttime' => null,
                'endtime' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'no_id' => '2',
                'weeks' => null,
                'status' => null,
                'starttime' => null,
                'endtime' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'no_id' => '3',
                'weeks' => null,
                'status' => null,
                'starttime' => null,
                'endtime' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'no_id' => '4',
                'weeks' => null,
                'status' => null,
                'starttime' => null,
                'endtime' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'no_id' => '5',
                'weeks' => null,
                'status' => null,
                'starttime' => null,
                'endtime' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'no_id' => '6',
                'weeks' => null,
                'status' => null,
                'starttime' => null,
                'endtime' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'no_id' => '7',
                'weeks' => null,
                'status' => null,
                'starttime' => null,
                'endtime' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
        ]);

    }
}

