<?php

namespace Database\Seeders;

use App\Models\Translate;
use App\Models\EmailTemplate;
use App\Models\Ticket\Category;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Schema;
use Spatie\Permission\Models\Permission;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class Updateversion5_0 extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        DB::table('email_templates')->insert([
            [
                'code' => 'send_email_admin_panel_users_when_customer_given_rating',
                'title' => 'Send email to admin panel users when customer given rating to them.',
                'subject' => 'Rating is received from a customer',
                'body' => '<p>Dear {{ ticket_username }},</p><p>We wanted to inform you that a new rating has been submitted by a customer.</p><p><strong>Details:</strong></p><ul><li><strong>Customer Name:</strong>&nbsp;{{ username }}</li><li><strong>Rating:</strong> {{ rating_value }} stars</li><li><strong>Feedback:</strong>&nbsp;{{ comment }}</li></ul><p>To view rating details please visit this url : {{ ticket_admin_url }}<br></p><p>We value customer feedback and encourage you to review this rating to better understand customer satisfaction and areas for improvement.<br></p><p>Thank you for your continued efforts in delivering quality service.</p><p><br></p><p class="root-block-node" data-paragraphid="19" data-from-init="true" data-changed="false">Sincerely,</p><p class="root-block-node" data-paragraphid="20" data-from-init="true" data-changed="false">Support Team</p>',
                'variables_used' => 'ticket_username,username,rating_value,comment,ticket_admin_url',
                'created_at' => now(),
                'updated_at' => now()
            ],

            //mail to customers when employee gives reply to emailtoticket
            [
                'code' => 'send_email_when_employee_replyto_emailtotckt',
                'title' => 'Send email to users when employee gives reply for email to ticket',
                'subject' => 'You have received a new reply',
                'body' => '<p>Your Ticket ID: {{ticket_id}}</p><p>Recent Reply: {{comment}}</p>',
                'variables_used' => 'comment,ticket_id,ticket_username,ticket_title,ticket_category',
                'created_at' => now(),
                'updated_at' => now()
            ],

            // mail to customer when employee closed the email to ticket
            [
                'code' => 'send_email_when_employee_closed_emailtotckt',
                'title' => 'Send email to users when employee closed email to ticket',
                'subject' => 'Your ticket has been closed',
                'body' => '<p>Your Ticket ID: {{ticket_id}} has been closed by our agents.</p><p>Recent Reply: {{comment}}</p>',
                'variables_used' => 'comment,ticket_id,ticket_username,ticket_title,ticket_category',
                'created_at' => now(),
                'updated_at' => now()
            ],

            // mail to customer when a custom invoice is created on their name
            [
                'code' => 'when_a_customInvoice_is_created',
                'title' => 'Send an email to customer when a custom invoice is created for them.',
                'subject' => 'Custom invoice created for you.',
                'body' => '<p>Dear {{username}},</p><p>An invoice with reference number #{{invoiceId}} has been created for you. Please click on the below link to view the invoice and proceed to payment from there.</p><p><a href="{{invoice_url}}" target="_blank">Invoice URL</a>&nbsp;.</p><p>  DueDate : {{dueDate}}</p><p>Sincerely,</p><p>Support Team.</p>',
                'variables_used' => 'username,invoiceId,invoice_url,dueDate',
                'created_at' => now(),
                'updated_at' => now()
            ],

            // mail to customer when they request for a refund.
            [
                'code' => 'customer_raised_refund',
                'title' => 'Send an email to customer when they request for refund.',
                'variables_used' => 'username,invoice_id',
                'subject' => 'Recieved your refund request.',
                'body' => '<p>Dear {{username}},</p><p>We have noted your request for a refund, and we sincerely apologize for any inconvenience you may have experienced with our product.</p><p>Our team will be reviewing your refund request and will be updatating you soon.</p><p>If you have any additional questions or concerns, please feel free to reach out to us. We are here to assist you.</p><p>Thank you for your understanding.</p><p>Sincerely,</p><p>Support Team.</p>',
                'created_at' => now(),
                'updated_at' => now()
            ],

            // mail to admin when customer request for a refund.
            [
                'code' => 'customer_raised_refund_mail_for_admin',
                'title' => 'Send an email to employees when customers request for refund.',
                'variables_used' => 'customer_name,invoice_id',
                'subject' => 'Recieved a new refund request from customer.',
                'body' => '<p>Dear Admin,</p><p>We recieved a new refund request from <strong>{{customer_name}}</strong> for invoice number <strong>#{{invoice_id}}</strong>.</p><p>Please review the refund request and update the customer as soon as possible.</p><p>Sincerely,</p><p>Support Team.</p>',
                'created_at' => now(),
                'updated_at' => now()
            ],

            // mail to employee when customer sends a refund comment
            [
                'code' => 'employee_send_refund_comment_from_customer',
                'title' => 'Send an email to employees when customers commented for a refund.',
                'variables_used' => 'username,invoice_id,refund_request_page_url',
                'subject' => 'Recieved a new refund comment from customer.',
                'body' => '<p>Dear Admin,</p><p>A new comment has posted from customer.</p>Please click on the below link to view the comment.</p><p><a href="{{refund_request_page_url}}" target="_blank">View Refund Comment</a>&nbsp;.</p><p>Sincerely,</p><p>Support Team.</p>',
                'created_at' => now(),
                'updated_at' => now()
            ],

            // Mail to customer when admin sends a refund comment
            [
                'code' => 'customer_send_refund_comment_from_admin',
                'title' => 'Send an email to customer when employees commented for a customer raised refund.',
                'variables_used' => 'username,invoice_id,refund_request_page_url',
                'subject' => 'Recieved a new comment for your refund.',
                'body' => '<p>Dear {{username}},</p><p>You have got a new reply for your refund for #{{invoice_id}} , and we sincerely apologize for any inconvenience you may have experienced with our product.</p><p>Our team will be reviewing your refund request and will be updatating you soon.</p><p>If you have any additional questions or concerns, please feel free to reach out to us. We are here to assist you.</p><p>Thank you for your understanding.</p><p>Sincerely,</p><p>Support Team.</p>',
                'created_at' => now(),
                'updated_at' => now()
            ],

            // Mail to customer when admin rejects refund request
            [
                'code' => 'customer_refund_rejected',
                'title' => 'Send an email to customer when employees rejected the refund',
                'variables_used' => 'username,invoice_id',
                'subject' => 'Refund rejected',
                'body' => '<p>Dear {{username}},</p><p>The refund request for #{{invoice_id}} has been rejected.</p><p>If you have any additional questions or concerns, please feel free to reach out to us. We are here to assist you.</p><p>Thank you for your understanding.</p><p>Sincerely,</p><p>Support Team.</p>',
                'created_at' => now(),
                'updated_at' => now()
            ],

            // Mail to customer when admin approves a refund
            [
                'code' => 'customer_refund_approved',
                'title' => 'Send an email to customer when employee approved the refund',
                'variables_used' => 'username,invoice_id',
                'subject' => 'Refund Approved',
                'body' => '<p>Dear {{username}},</p><p>The refund request for #{{invoice_id}} has been approved.</p><p>If you have any additional questions or concerns, please feel free to reach out to us. We are here to assist you.</p><p>Thank you for your understanding.</p><p>Sincerely,</p><p>Support Team.</p>',
                'created_at' => now(),
                'updated_at' => now()
            ],


        ]);

        $emailtemplate = EmailTemplate::where('code', 'admin_send_email_ticket_created')->first();
        $emailtemplate->variables_used = 'ticket_username,ticket_id, ticket_title,ticket_status,ticket_description,ticket_customer_url,ticket_admin_url,ticket_category,status';
        $emailtemplate->save();

        $emailtemplate = EmailTemplate::where('code', 'admin_send_email_ticket_reply')->first();
        $emailtemplate->variables_used = 'ticket_username,ticket_title,ticket_id,ticket_status,comment,ticket_admin_url,ticket_customer_url,ticket_category,status';
        $emailtemplate->save();

        $emailtemplate = EmailTemplate::where('code', 'when_ticket_assign_to_other_employee')->first();
        $emailtemplate->variables_used = 'ticket_username,ticket_id,ticket_title,ticket_description,ticket_admin_url,ticket_category,status';
        $emailtemplate->save();

        $emailtemplate = EmailTemplate::where('code', 'admin_sendemail_whenticketclosed')->first();
        $emailtemplate->variables_used = 'ticket_username,ticket_id,ticket_title,ticket_description,ticket_status,comment,ticket_customer_url,ticket_admin_url,ticket_category,status';
        $emailtemplate->save();

        $emailtemplate = EmailTemplate::where('code', 'admin_sendemail_whenticketreopen')->first();
        $emailtemplate->variables_used = 'ticket_username,ticket_id,ticket_title,ticket_description,ticket_status,ticket_customer_url,ticket_admin_url,ticket_category,status';
        $emailtemplate->save();

        $emailtemplate = EmailTemplate::where('code', 'send_mail_admin_panel_users_when_category_changed')->first();
        $emailtemplate->variables_used = 'ticket_id,ticket_title,ticket_description,ticket_status,ticket_oldcategory,ticket_changedcategory,ticket_customer_url,ticket_admin_url,ticket_category,status';
        $emailtemplate->save();

        $emailtemplate = EmailTemplate::where('code', 'send_mail_to_admin_when_ticket_note_created')->first();
        $emailtemplate->variables_used = 'ticket_id,note_username,ticket_note,ticket_admin_url,ticket_category,status';
        $emailtemplate->save();

        $emailtemplate = EmailTemplate::where('code', 'Send_email_to_admin_when_ticket_draft_created')->first();
        $emailtemplate->variables_used = 'username,ticket_id,ticket_description,created_or_respond,ticket_admin_url,ticket_category,status';
        $emailtemplate->save();

        $emailtemplate = EmailTemplate::where('code', 'send_mail_to_agent_when_ticket_closed_by_admin_or_agent')->first();
        $emailtemplate->variables_used = 'closed_agent_name,closed_agent_role,ticket_username,ticket_title,ticket_id,comment,ticket_status,ticket_customer_url,ticket_admin_url,ticket_category';
        $emailtemplate->save();

        $emailtemplate = EmailTemplate::where('code', 'two_factor_authentication_otp_send')->first();
        $emailtemplate->variables_used = 'otp,guestemail,guestname';
        $emailtemplate->save();

        Category::where('display', 'both')->update(['display' => 'all']);

        DB::table('settings')->insert([
            // invoice address settings
            [
                'key' => 'companyName',
                'value' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'addressLine1',
                'value' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'addressLine2',
                'value' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'cityName',
                'value' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'stateName',
                'value' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'zipPostalCode',
                'value' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'countryName',
                'value' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'taxName',
                'value' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'taxId',
                'value' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],

            [
                'key' => 'customInvoiceId',
                'value' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],


            // payment integration settings
            [
                'key' => 'enableStripe',
                'value' => 'off',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'stripeKey',
                'value' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'stripeSecret',
                'value' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'enablePaypal',
                'value' => 'off',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'paypalKey',
                'value' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'paypalSecret',
                'value' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            // Refund Settings
            [
                'key' => 'enableRefund',
                'value' => 'off',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'refundDays',
                'value' => '15',
                'created_at' => now(),
                'updated_at' => now()
            ],

            // Auto Invoice Cancel Setting
            [
                'key' => 'autoInvoiceCancelEnable',
                'value' => 'off',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'invoiceCancelDays',
                'value' => '7',
                'created_at' => now(),
                'updated_at' => now()
            ],

            // Auto Invoice delete Setting
            [
                'key' => 'autoinvoicedelete',
                'value' => 'off',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'autodeleteinvoiceDays',
                'value' => '7',
                'created_at' => now(),
                'updated_at' => now()
            ],


            [
                'key' => 'liveChatIcon',
                'value' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],

            // Gemini API Settings
            [
                'key' => 'geminiApiKey',
                'value' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'enableGeminiApi',
                'value' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],

            //Google translate settings
            [
                'key' => 'emp_google_translate',
                'value' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'cust_google_translate',
                'value' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'businesshourofflinemsg',
                'value' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'cust_email_verification',
                'value' => "on",
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'taxPercent',
                'value' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'paypalDefault',
                'value' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'stripeDefault',
                'value' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'templateHeaderColor',
                'value' => 'rgb(51 ,102 ,255)',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'templateFooterColor',
                'value' => 'rgb(35, 41, 58)',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'offlineTextTitle',
                'value' => 'We Are Offline',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'key' => 'offlineTextMessage',
                'value' => 'We’re currently offline, but don’t worry, we’ll be back soon to assist you. Meanwhile, explore our knowledge base for answers or create a ticket for urgent matters. Thank you for your understanding and patience!',
                'created_at' => now(),
                'updated_at' => now()
            ],


        ]);

        DB::table('customizeerrors')->insert([
            [
                'errorname' => 'redirectionURL',
                'errorvalue' => null,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'errorname' => 'MAINTENANCE_MODE',
                'errorvalue' => 'off',
                'created_at' => now(),
                'updated_at' => now()
            ],
        ]);

        DB::table('currencies')->insert([
            [
                'code' => 'USD',
                'position' => 'Prefix',
                'conversion_factor' => 1,
                'decimal' => 2,
                'status' => 1,
                'created_at' => now(),
                'updated_at' => now()
            ]
        ]);


        // Get all unique language codes from the Translate table
        $languages = Translate::distinct()->pluck('lang_code');
        $translationsExported = false;
        if ($languages) {
            foreach ($languages as $lang) {
                $this->seedTranslations($lang);
                $translationsExported = true;
            }
        }
    }

    function seedTranslations($lang)
    {
        // Path to the JSON language file
        $path = base_path("lang/{$lang}.json");
        $langDirectory = dirname($path);

        // Create directory if it doesn't exist
        if (!File::exists($langDirectory)) {
            File::makeDirectory($langDirectory, 0755, true);
        }

        // Initialize translations as an empty array
        $translations = [];

        // Load existing translations from the JSON file if it exists
        if (File::exists($path)) {
            $translations = json_decode(File::get($path), true);

            // Ensure translations is an array
            if (!is_array($translations)) {
                $translations = [];
            }
        }

        // Get all translations from the database for the specified language
        $dbTranslations = Translate::where('lang_code', $lang)->get();

        // Populate the translations array with database values
        foreach ($dbTranslations as $translation) {
            $group = $translation->group_langname;
            $key = $translation->key;
            $value = $translation->value;

            // Initialize group if it doesn't exist
            if (!isset($translations[$group])) {
                $translations[$group] = [];
            }

            // Update the translation or add it if it doesn't exist
            $translations[$group][$key] = $value;
        }

        // Prepare the content for the file with double quotations
        $content = json_encode($translations, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);

        // Save the updated translations to the JSON file
        File::put($path, $content);
    }
}
